/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.context.session;

import io.vertx.ext.web.Session;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.util.serializer.JavaSerializer;
import org.pac4j.vertx.VertxWebContext;

public class VertxSessionStore
implements SessionStore {
    private final io.vertx.ext.web.sstore.SessionStore sessionStore;
    private static final JavaSerializer JAVA_SERIALIZER = new JavaSerializer();
    private final Session providedSession;

    public VertxSessionStore(io.vertx.ext.web.sstore.SessionStore sessionStore) {
        this(sessionStore, null);
    }

    public VertxSessionStore(io.vertx.ext.web.sstore.SessionStore sessionStore, Session providedSession) {
        this.sessionStore = sessionStore;
        this.providedSession = providedSession;
    }

    protected Session getVertxSession(WebContext context) {
        if (this.providedSession != null) {
            return this.providedSession;
        }
        return ((VertxWebContext)context).getVertxSession();
    }

    public Optional<String> getSessionId(WebContext context, boolean b) {
        Session vertxSession = this.getVertxSession(context);
        if (vertxSession != null) {
            return Optional.of(this.getVertxSession(context).id());
        }
        return Optional.empty();
    }

    public Optional<Object> get(WebContext context, String key) {
        Session vertxSession = this.getVertxSession(context);
        if (vertxSession != null) {
            String value;
            if (key.equals("pac4jUserProfiles") && (value = (String)vertxSession.get(key)) != null) {
                byte[] inputBytes = Base64.getDecoder().decode(value);
                return Optional.ofNullable(JAVA_SERIALIZER.deserializeFromBytes(inputBytes));
            }
            return Optional.ofNullable(vertxSession.get(key));
        }
        return Optional.empty();
    }

    public void set(WebContext context, String key, Object value) {
        Session vertxSession = this.getVertxSession(context);
        if (vertxSession != null) {
            if (value == null) {
                vertxSession.remove(key);
            } else if (key.equals("pac4jUserProfiles")) {
                vertxSession.put(key, (Object)Base64.getEncoder().encodeToString(JAVA_SERIALIZER.serializeToBytes(value)));
            } else {
                vertxSession.put(key, value);
            }
        }
    }

    public boolean destroySession(WebContext context) {
        Session vertxSession = this.getVertxSession(context);
        if (vertxSession != null) {
            vertxSession.destroy();
            return true;
        }
        return false;
    }

    public Optional<Object> getTrackableSession(WebContext context) {
        Session vertxSession = this.getVertxSession(context);
        if (vertxSession != null) {
            return Optional.of(this.getVertxSession(context).id());
        }
        return Optional.empty();
    }

    public Optional<SessionStore> buildFromTrackableSession(WebContext context, Object trackableSession) {
        if (trackableSession != null) {
            CompletableFuture vertxSessionFuture = new CompletableFuture();
            this.sessionStore.get((String)trackableSession, asyncResult -> {
                if (asyncResult.succeeded()) {
                    vertxSessionFuture.complete((Session)asyncResult.result());
                } else {
                    vertxSessionFuture.completeExceptionally(asyncResult.cause());
                }
            });
            CompletionStage pac4jSessionFuture = vertxSessionFuture.thenApply(session -> {
                if (session != null) {
                    return new VertxSessionStore(this.sessionStore, (Session)session);
                }
                return null;
            });
            try {
                return Optional.ofNullable((SessionStore)((CompletableFuture)pac4jSessionFuture).get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TechnicalException((Throwable)e);
            }
        }
        return Optional.empty();
    }

    public boolean renewSession(WebContext context) {
        Session vertxSession = this.getVertxSession(context);
        if (vertxSession != null) {
            vertxSession.regenerateId();
            return true;
        }
        return false;
    }
}

