/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.core.store;

import io.vertx.core.Vertx;
import io.vertx.rxjava.core.shareddata.AsyncMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.store.Store;
import org.pac4j.vertx.core.store.VertxMapStoreBase;
import rx.Single;
import rx.functions.Func1;

public class VertxClusteredMapStore<K, V>
extends VertxMapStoreBase
implements Store<K, V> {
    private final io.vertx.rxjava.core.Vertx rxVertx;
    private final int blockingTimeoutSeconds;

    public VertxClusteredMapStore(Vertx vertx) {
        this(vertx, 1);
    }

    public VertxClusteredMapStore(Vertx vertx, int timeoutSeconds) {
        this.rxVertx = io.vertx.rxjava.core.Vertx.newInstance((Vertx)vertx);
        this.blockingTimeoutSeconds = timeoutSeconds;
    }

    public Optional<V> get(K key) {
        this.voidAsyncOpToBlocking((Func1<AsyncMap, Single>)((Func1)map -> map.rxGet(key)));
        CompletableFuture valueFuture = new CompletableFuture();
        this.rxVertx.sharedData().rxGetClusterWideMap("pac4jSharedData").flatMap(map -> map.rxGet(key)).subscribe(valueFuture::complete);
        try {
            return Optional.ofNullable(valueFuture.get(this.blockingTimeoutSeconds, TimeUnit.SECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public void set(K key, V value) {
        this.voidAsyncOpToBlocking((Func1<AsyncMap, Single>)((Func1)map -> map.rxPut(key, value)));
    }

    public void remove(K key) {
        this.voidAsyncOpToBlocking((Func1<AsyncMap, Single>)((Func1)map -> map.rxRemove(key)));
    }

    public void voidAsyncOpToBlocking(Func1<AsyncMap, Single> asyncOp) {
        CompletableFuture future = new CompletableFuture();
        this.rxVertx.sharedData().rxGetAsyncMap("pac4jSharedData").map(asyncOp).subscribe(result -> future.complete(null));
        try {
            future.get(this.blockingTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

