/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.net.URISyntaxException;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.vertx.auth.Pac4jAuthProvider;
import org.pac4j.vertx.handler.impl.CallbackHandler;
import org.pac4j.vertx.handler.impl.CallbackHandlerOptions;
import org.pac4j.vertx.handler.impl.SecurityHandler;
import org.pac4j.vertx.handler.impl.SecurityHandlerOptions;

public class CallbackDeployingPac4jAuthHandler
extends SecurityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackDeployingPac4jAuthHandler.class);

    public CallbackDeployingPac4jAuthHandler(Vertx vertx, SessionStore sessionStore, Config config, Router router, Pac4jAuthProvider authProvider, SecurityHandlerOptions options, CallbackHandlerOptions callbackOptions) {
        super(vertx, sessionStore, config, authProvider, options);
        URI uri;
        CommonHelper.assertNotNull((String)"router", (Object)router);
        CommonHelper.assertNotBlank((String)"callbackUrl", (String)config.getClients().getCallbackUrl());
        try {
            uri = new URI(config.getClients().getCallbackUrl());
        }
        catch (URISyntaxException e) {
            LOG.error((Object)e.getMessage());
            throw this.toTechnicalException(e);
        }
        router.route(HttpMethod.GET, uri.getPath()).handler(this.authResultHandler(vertx, sessionStore, config, callbackOptions));
    }

    private Handler<RoutingContext> authResultHandler(Vertx vertx, SessionStore sessionStore, Config config, CallbackHandlerOptions callbackOptions) {
        return new CallbackHandler(vertx, sessionStore, config, callbackOptions);
    }
}

