/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.vertx.handler.impl;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.vertx.VertxWebContext;
import org.pac4j.vertx.handler.impl.LogoutHandlerOptions;
import org.pac4j.vertx.http.VertxHttpActionAdapter;

public class LogoutHandler
implements Handler<RoutingContext> {
    protected final String defaultUrl;
    protected final String logoutUrlPattern;
    protected final Config config;
    private final Vertx vertx;
    private final SessionStore sessionStore;
    private final boolean localLogout;
    private final boolean destroySession;
    private final boolean centralLogout;

    public LogoutHandler(Vertx vertx, SessionStore sessionStore, LogoutHandlerOptions options, Config config) {
        this.defaultUrl = options.getDefaultUrl();
        this.logoutUrlPattern = options.getLogoutUrlPattern();
        this.config = config;
        this.vertx = vertx;
        this.sessionStore = sessionStore;
        this.localLogout = options.isLocalLogout();
        this.destroySession = options.isDestroySession();
        this.centralLogout = options.isCentralLogout();
    }

    public void handle(RoutingContext routingContext) {
        LogoutLogic bestLogic = FindBest.logoutLogic(null, (Config)this.config, (LogoutLogic)DefaultLogoutLogic.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)VertxHttpActionAdapter.INSTANCE);
        VertxWebContext webContext = new VertxWebContext(routingContext, this.sessionStore);
        this.vertx.executeBlocking(future -> {
            bestLogic.perform((WebContext)webContext, this.sessionStore, this.config, bestAdapter, this.defaultUrl, this.logoutUrlPattern, Boolean.valueOf(this.localLogout), Boolean.valueOf(this.destroySession), Boolean.valueOf(this.centralLogout));
            future.complete(null);
        }, false, asyncResult -> {
            if (asyncResult.failed()) {
                routingContext.fail((Throwable)new TechnicalException(asyncResult.cause()));
            }
        });
    }
}

