/*
 * Decompiled with CFR 0.152.
 */
package panda.std;

import org.junit.jupiter.api.Assertions;
import panda.std.Result;

public final class ResultAssertions {
    private ResultAssertions() {
    }

    public static <VALUE> VALUE assertOk(Result<? extends VALUE, ?> result) {
        if (result.isErr()) {
            Assertions.fail((String)("Expected success, but result errored with: <" + result.getError() + ">"));
        }
        return (VALUE)result.get();
    }

    public static <VALUE> void assertOk(VALUE value, Result<? extends VALUE, ?> result) {
        ResultAssertions.assertOk(result);
        Assertions.assertEquals((Object)Result.ok(value), result);
    }

    public static <ERROR> ERROR assertError(Result<?, ERROR> result) {
        if (result.isOk()) {
            Assertions.fail((String)("Expected failure, but result succeeded with: <" + result.get() + ">"));
        }
        return (ERROR)result.getError();
    }

    public static <ERROR> void assertError(ERROR error, Result<?, ERROR> result) {
        ResultAssertions.assertError(result);
        Assertions.assertEquals((Object)Result.error(error), result);
    }
}

