/*
 * Decompiled with CFR 0.152.
 */
package panda.std;

import java.util.function.Supplier;

public class Lazy<T>
implements Supplier<T> {
    private Supplier<T> supplier;
    private boolean initialized;
    private T value;

    public Lazy(T value) {
        this.initialized = true;
        this.value = value;
    }

    public Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static Lazy<Void> ofRunnable(Runnable runnable) {
        return new Lazy<Void>(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public synchronized T get() {
        if (this.initialized) {
            return this.value;
        }
        this.initialized = true;
        this.value = this.supplier.get();
        return this.value;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

