/*
 * Decompiled with CFR 0.152.
 */
package panda.std;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import panda.std.AttemptFailedException;
import panda.std.Blank;
import panda.std.Case;
import panda.std.Pair;
import panda.std.Result;
import panda.std.collection.SingletonIterator;
import panda.std.function.ThrowingRunnable;
import panda.std.function.ThrowingSupplier;
import panda.std.reactive.Completable;
import panda.std.stream.PandaStream;

public class Option<T>
implements Iterable<T>,
Serializable {
    private static final Option<?> NONE = new Option<Object>(null);
    @Nullable
    protected T value;

    protected Option(@Nullable T value) {
        this.value = value;
    }

    public static <T> Option<T> none() {
        return NONE;
    }

    public static Option<Blank> blank() {
        return Option.of(Blank.BLANK);
    }

    public static <T> Option<@NotNull T> of(@Nullable T value) {
        return value != null ? new Option<T>(value) : Option.none();
    }

    public static <T> Option<T> ofOptional(Optional<T> optional) {
        return Option.of(optional.orElse(null));
    }

    public static <T> Option<Completable<T>> withCompleted(T value) {
        return Option.of(Completable.completed(value));
    }

    public static <T> Option<T> when(boolean condition, @Nullable T value) {
        return Option.when(condition, () -> value);
    }

    public static <T> Option<T> when(boolean condition, Supplier<@Nullable T> valueSupplier) {
        return condition ? Option.of(valueSupplier.get()) : Option.none();
    }

    public static <T> Option<T> flatWhen(boolean condition, Option<T> value) {
        return condition ? value : Option.none();
    }

    public static <T> Option<T> flatWhen(boolean condition, Supplier<Option<T>> supplier) {
        return condition ? supplier.get() : Option.none();
    }

    @Deprecated
    public static <T, E extends Throwable> Option<T> attempt(Class<E> throwableType, ThrowingSupplier<T, E> supplier) throws AttemptFailedException {
        return Option.supplyThrowing(throwableType, supplier);
    }

    public static Option<Blank> runThrowing(ThrowingRunnable<Exception> runnable) throws AttemptFailedException {
        return Option.supplyThrowing(() -> {
            runnable.run();
            return Blank.BLANK;
        });
    }

    public static <T> Option<T> supplyThrowing(ThrowingSupplier<T, Exception> supplier) throws AttemptFailedException {
        return Option.supplyThrowing(Exception.class, supplier);
    }

    public static <T, E extends Throwable> Option<T> supplyThrowing(Class<E> throwableType, ThrowingSupplier<T, E> supplier) throws AttemptFailedException {
        try {
            return Option.of(supplier.get());
        }
        catch (Throwable throwable) {
            if (throwableType.isAssignableFrom(throwable.getClass())) {
                return Option.none();
            }
            throw new AttemptFailedException(throwable);
        }
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(@Nullable Object to) {
        if (!(to instanceof Option)) {
            return false;
        }
        return this.contentEquals(((Option)to).value);
    }

    public boolean contentEquals(@Nullable Object to) {
        return Objects.equals(this.value, to);
    }

    public String toString() {
        return this.isEmpty() ? "Option{EMPTY}" : "Option{'" + this.value + "'}";
    }

    @Override
    public Iterator<T> iterator() {
        return this.isDefined() ? new SingletonIterator<T>(this.value) : Collections.emptyIterator();
    }

    public Option<T> filter(Predicate<T> predicate) {
        return this.isDefined() && predicate.test(this.value) ? this : Option.none();
    }

    public Option<T> filterNot(Predicate<T> predicate) {
        return this.filter(value -> !predicate.test(value));
    }

    public <R> Option<R> map(Function<T, R> function) {
        return this.isDefined() ? Option.of(function.apply(this.value)) : Option.none();
    }

    public <R> Option<R> flatMap(Function<T, Option<R>> function) {
        return this.isDefined() ? function.apply(this.value) : Option.none();
    }

    public <R> Option<Pair<T, R>> associateWith(Function<T, Option<R>> supplier) {
        return this.flatMap(a -> ((Option)supplier.apply(a)).map(b -> new Pair<Object, Object>(a, b)));
    }

    @SafeVarargs
    public final <R> Option<R> match(Case<T, R> ... cases) {
        return this.match(Arrays.asList(cases));
    }

    public <R> Option<R> match(List<? extends Case<T, R>> cases) {
        for (Case<T, R> currentCase : cases) {
            if (!currentCase.getCondition().test(this.value)) continue;
            return Option.of(currentCase.getValue().apply(this.value));
        }
        return Option.none();
    }

    public boolean is(Predicate<T> predicate) {
        return this.isDefined() && predicate.test(this.value);
    }

    public boolean isNot(Predicate<T> predicate) {
        return this.isDefined() && !predicate.test(this.value);
    }

    public <S> Option<S> is(Class<S> type) {
        return this.filter(type::isInstance).map(type::cast);
    }

    public Option<T> isNot(Class<?> type) {
        return this.filterNot(type::isInstance);
    }

    public Option<T> peek(Consumer<T> consumer) {
        if (this.isDefined()) {
            consumer.accept(this.value);
        }
        return this;
    }

    public Option<T> peekIf(Predicate<T> predicate, Consumer<T> consumer) {
        return this.peek(value -> {
            if (predicate.test(value)) {
                consumer.accept(value);
            }
        });
    }

    public Option<T> peekIfNot(Predicate<T> predicate, Consumer<T> consumer) {
        return this.peek(value -> {
            if (!predicate.test(value)) {
                consumer.accept(value);
            }
        });
    }

    public Option<T> onEmpty(Runnable runnable) {
        if (this.isEmpty()) {
            runnable.run();
        }
        return this;
    }

    public Option<T> orElse(T value) {
        return this.isDefined() ? this : Option.of(value);
    }

    public Option<T> orElse(Option<T> value) {
        return this.isDefined() ? this : value;
    }

    public Option<T> orElse(Supplier<Option<T>> supplier) {
        return this.isDefined() ? this : supplier.get();
    }

    public Option<T> orElseSupply(Supplier<T> supplier) {
        return this.isDefined() ? this : Option.of(supplier.get());
    }

    public <E extends Throwable> T orThrow(Supplier<E> exceptionSupplier) throws E {
        if (this.isEmpty()) {
            throw (Throwable)exceptionSupplier.get();
        }
        return this.value;
    }

    public T orElseGet(T elseValue) {
        return this.isDefined() ? this.value : elseValue;
    }

    public T orElseGet(Supplier<T> supplier) {
        return this.isDefined() ? this.value : supplier.get();
    }

    @Deprecated
    @Nullable
    public T getOrNull() {
        return this.value;
    }

    @Nullable
    public T orNull() {
        return this.value;
    }

    public T get() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Value is not defined");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.isDefined();
    }

    public boolean isDefined() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public <R> PandaStream<R> toStream(Function<T, Stream<R>> function) {
        return this.isDefined() ? PandaStream.of(function.apply(this.value)) : PandaStream.empty();
    }

    public PandaStream<T> toStream() {
        return PandaStream.of(this.toJavaStream());
    }

    public Stream<T> toJavaStream() {
        return this.isDefined() ? Stream.of(this.value) : Stream.empty();
    }

    public <E> Result<T, E> toResult(E orElse) {
        return this.toResult(() -> orElse);
    }

    public <E> Result<T, E> toResult(Supplier<E> orElse) {
        return this.isDefined() ? Result.ok(this.get()) : Result.error(orElse.get());
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }
}

