/*
 * Decompiled with CFR 0.152.
 */
package panda.std;

import java.util.Objects;
import panda.std.Triple;

public class Pair<A, B> {
    protected final A first;
    protected final B second;

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public static <A, B> Pair<A, B> of(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public <C> Triple<A, B, C> add(C third) {
        return Triple.of(this.first, this.second, third);
    }

    public <R> Pair<R, B> withFirst(R newValue) {
        return new Pair<R, B>(newValue, this.second);
    }

    public <R> Pair<A, R> withSecond(R newValue) {
        return new Pair<A, R>(this.first, newValue);
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public boolean equals(Object to) {
        if (this == to) {
            return true;
        }
        if (to == null || this.getClass() != to.getClass()) {
            return false;
        }
        Pair pair = (Pair)to;
        return Objects.equals(this.first, pair.first) && Objects.equals(this.second, pair.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "['" + this.first + "', '" + this.second + "']";
    }
}

