/*
 * Decompiled with CFR 0.152.
 */
package panda.std.reactive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import panda.std.Option;
import panda.std.reactive.DetailedSubscriber;
import panda.std.reactive.Publisher;
import panda.std.reactive.Subscriber;

public class Reference<V>
implements Publisher<Reference<V>, V> {
    protected final Collection<DetailedSubscriber<? super V>> subscribers = new ArrayList<DetailedSubscriber<? super V>>();
    protected V value;

    public Reference(V value) {
        this.set(value);
    }

    void set(V newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("Reference does not support null values");
        }
        V oldValue = this.value;
        this.value = newValue;
        this.notifySubscribers(oldValue, newValue);
    }

    protected void notifySubscribers(V oldValue, V newValue) {
        this.subscribers.forEach(subscriber -> subscriber.onComplete(oldValue, newValue));
    }

    @Override
    public Reference<V> subscribe(Subscriber<? super V> subscriber) {
        return this.subscribeDetailed((oldValue, newValue) -> subscriber.onComplete((Object)newValue), false);
    }

    public Reference<V> subscribe(Subscriber<? super V> subscriber, boolean immediately) {
        return this.subscribeDetailed((oldValue, newValue) -> subscriber.onComplete((Object)newValue), immediately);
    }

    public Reference<V> subscribeDetailed(DetailedSubscriber<? super V> subscriber) {
        return this.subscribeDetailed(subscriber, false);
    }

    public Reference<V> subscribeDetailed(DetailedSubscriber<? super V> subscriber, boolean immediately) {
        if (immediately) {
            subscriber.onComplete(this.get(), this.get());
        }
        this.subscribers.add(subscriber);
        return this;
    }

    public V get() {
        return this.value;
    }

    public <R> R map(Function<V, R> function) {
        return function.apply(this.get());
    }

    public Reference<V> peek(Consumer<V> consumer) {
        consumer.accept(this.get());
        return this;
    }

    public <R> Reference<R> computed(Function<V, R> recalculateFunction) {
        Reference computed = new Reference(recalculateFunction.apply(this.get()));
        this.subscribe((VALUE value) -> computed.set(recalculateFunction.apply(value)));
        return computed;
    }

    public Option<V> toOption() {
        return Option.of(this.get());
    }

    public Class<V> getType() {
        return this.value.getClass();
    }

    @NotNull
    public static <T> Reference<T> reference(T value) {
        return new Reference<T>(value);
    }

    @NotNull
    public static <T> Reference<T> computed(Dependencies dependencies, Supplier<T> recalculateFunction) {
        return dependencies.computed(recalculateFunction);
    }

    public static class Dependencies {
        final List<Reference<?>> references;

        Dependencies(List<Reference<?>> references) {
            this.references = references;
        }

        @NotNull
        public <T> Reference<T> computed(Supplier<T> recalculateFunction) {
            Reference computed = Reference.reference(recalculateFunction.get());
            this.references.forEach(reference -> reference.subscribe(arg_0 -> Dependencies.lambda$computed$0(computed, (Supplier)recalculateFunction, arg_0)));
            return computed;
        }

        public static Dependencies dependencies(List<Reference<?>> references) {
            return new Dependencies(references);
        }

        public static Dependencies dependencies(Reference<?> ... references) {
            return new Dependencies(Arrays.asList(references));
        }

        private static /* synthetic */ void lambda$computed$0(Reference computed, Supplier recalculateFunction, Object newValue) {
            computed.set(recalculateFunction.get());
        }
    }
}

