/*
 * Decompiled with CFR 0.152.
 */
package panda.std.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import panda.std.Option;
import panda.std.Pair;
import panda.std.Result;
import panda.std.stream.PandaCollectors;
import panda.std.stream.StreamUtils;
import panda.std.stream.TakeWhileSpliterator;

public class PandaStream<T>
implements AutoCloseable {
    private Stream<T> stream;

    private PandaStream(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public void close() {
        this.stream.close();
    }

    public <R> PandaStream<R> stream(Function<Stream<T>, Stream<R>> function) {
        return new PandaStream<R>(function.apply(this.stream));
    }

    public PandaStream<T> concat(Stream<T> stream) {
        this.stream = Stream.concat(this.stream, stream);
        return this;
    }

    public PandaStream<T> concat(PandaStream<T> pandaStream) {
        this.stream = Stream.concat(this.stream, pandaStream.stream);
        return this;
    }

    public PandaStream<T> concat(Iterable<T> iterable) {
        return this.concat(PandaStream.of(iterable));
    }

    @SafeVarargs
    public final PandaStream<T> concat(T ... elements) {
        return this.concat(Stream.of(elements));
    }

    public <R> PandaStream<Pair<T, R>> associateWith(R value) {
        return this.map(element -> Pair.of(element, value));
    }

    public <R> PandaStream<R> transform(Function<Stream<T>, Stream<R>> function) {
        return this.stream(function);
    }

    public <R> PandaStream<R> map(Function<T, R> function) {
        return new PandaStream<R>(this.stream.map(function));
    }

    public <A, R> PandaStream<R> mapWith(A with, BiFunction<A, T, R> function) {
        return this.map(element -> function.apply(with, element));
    }

    public <R> PandaStream<R> mapOpt(Function<T, Option<R>> function) {
        return this.map(function).filter(Option::isDefined).map(Option::get);
    }

    public <R> PandaStream<R> flatMap(Function<T, Iterable<R>> function) {
        return new PandaStream(this.stream.flatMap((? super T value) -> StreamSupport.stream(((Iterable)function.apply(value)).spliterator(), false)));
    }

    public <A, R> PandaStream<R> flatMapWith(A with, BiFunction<A, T, Iterable<R>> function) {
        return this.flatMap(element -> (Iterable)function.apply(with, element));
    }

    public <R> PandaStream<R> flatMapStream(Function<T, Stream<R>> function) {
        return new PandaStream<R>(this.stream.flatMap(function));
    }

    public <S> PandaStream<S> is(Class<S> type) {
        if (type.isPrimitive()) {
            type = StreamUtils.convertPrimitiveToWrapper(type);
        }
        return this.filter(type::isInstance).map(type::cast);
    }

    public PandaStream<T> isNot(Class<?> type) {
        if (type.isPrimitive()) {
            type = StreamUtils.convertPrimitiveToWrapper(type);
        }
        return this.filterNot(type::isInstance);
    }

    public PandaStream<T> filter(Predicate<T> predicate) {
        return this.with(this.stream.filter(predicate));
    }

    public PandaStream<T> filterNot(Predicate<T> predicate) {
        return this.with(this.stream.filter((? super T obj) -> !predicate.test(obj)));
    }

    public <E> Result<PandaStream<T>, E> filterToResult(Function<? super T, Option<E>> predicate) {
        return this.findIterating(predicate).map(Result::error).orElseGet(Result.ok(this));
    }

    public <R, E> Result<R, List<E>> search(Function<T, Result<R, E>> searchFunction) {
        ArrayList errors = new ArrayList();
        return this.map(value -> ((Result)searchFunction.apply(value)).onError(errors::add)).filter(Result::isOk).head().map(Result::projectToValue).orElseGet(() -> Result.error(errors));
    }

    public PandaStream<T> distinct() {
        return this.with(this.stream.distinct());
    }

    public PandaStream<T> sorted() {
        return this.with(this.stream.sorted());
    }

    public PandaStream<T> sorted(Comparator<? super T> comparator) {
        return this.with(this.stream.sorted(comparator));
    }

    public PandaStream<T> shuffle() {
        return PandaStream.of(this.toShuffledList());
    }

    public PandaStream<T> skip(long n) {
        return this.with(this.stream.skip(n));
    }

    public Option<T> find(Predicate<T> predicate) {
        return this.filter(predicate).head();
    }

    public Option<T> head() {
        return Option.ofOptional(this.stream.findFirst());
    }

    public Option<T> last() {
        return Option.ofOptional(this.stream.reduce((first, second) -> second));
    }

    public Option<T> any() {
        return Option.ofOptional(this.stream.findAny());
    }

    public long count(Predicate<T> predicate) {
        return this.filter(predicate).count();
    }

    public long count() {
        return this.stream.count();
    }

    private PandaStream<T> with(Stream<T> stream) {
        this.stream = stream;
        return this;
    }

    public <A, R> R collect(Collector<? super T, A, R> collector) {
        return this.stream.collect(collector);
    }

    public <E extends Exception> PandaStream<T> throwIfNot(Predicate<T> condition, Function<T, E> exception) {
        return this.with(this.stream.peek(element -> {
            if (!condition.test(element)) {
                PandaStream.throwException((Throwable)exception.apply(element));
            }
        }));
    }

    private static <R, E extends Throwable> R throwException(Throwable throwable) throws E {
        throw throwable;
    }

    public PandaStream<T> takeWhile(Predicate<T> condition) {
        return new PandaStream(StreamSupport.stream(new TakeWhileSpliterator(this.stream.spliterator(), condition), false));
    }

    public PandaStream<T> forEach(Consumer<? super T> consumer) {
        this.stream.forEach(consumer);
        return this;
    }

    public <E> Result<PandaStream<T>, E> forEachByResult(Function<T, Option<E>> predicate) {
        return this.findIterating(predicate).map(Result::error).orElseGet(Result.ok(this));
    }

    public <R> Option<R> findIterating(Function<? super T, Option<R>> predicate) {
        Iterator<T> iterator = this.duplicate().iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            Option<R> result = predicate.apply(element);
            if (!result.isDefined()) continue;
            return result;
        }
        return Option.none();
    }

    public PandaStream<T> duplicate() {
        List<T> buffer = this.toList();
        this.stream = buffer.stream();
        return PandaStream.of(buffer);
    }

    public T[] toArray(IntFunction<T[]> function) {
        return this.stream.toArray(function);
    }

    public List<T> toList() {
        return this.stream.collect(Collectors.toList());
    }

    public List<T> toShuffledList(Random random) {
        return this.stream.collect(PandaCollectors.shufflingCollector(random));
    }

    public List<T> toShuffledList() {
        return this.toShuffledList(ThreadLocalRandom.current());
    }

    public Set<T> toSet() {
        return this.stream.collect(Collectors.toSet());
    }

    public <K, V> Map<K, V> toMap(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return this.toMap(HashMap::new, keyMapper, valueMapper);
    }

    public <K, V> Map<K, V> toMap(Supplier<Map<K, V>> mapSupplier, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return this.stream.collect(Collectors.toMap(keyMapper, valueMapper, PandaCollectors.throwingMerger(), mapSupplier));
    }

    public <K, V> Map<K, V> toMapByPair(Supplier<Map<K, V>> mapSupplier, Function<T, Pair<K, V>> mapper) {
        return this.toMap(mapSupplier, key -> ((Pair)mapper.apply(key)).getFirst(), value -> ((Pair)mapper.apply(value)).getSecond());
    }

    public <K, V> Map<K, V> toMapByPair(Function<T, Pair<K, V>> mapper) {
        return this.toMapByPair(HashMap::new, mapper);
    }

    public Stream<T> toStream() {
        return this.stream;
    }

    public Iterator<T> iterator() {
        return this.stream.iterator();
    }

    public static <T> PandaStream<T> of(Stream<T> stream) {
        return new PandaStream<T>(stream);
    }

    public static <T> PandaStream<T> of(Collection<T> collection) {
        return PandaStream.of(collection.stream());
    }

    public static <T> PandaStream<T> of(Iterable<T> iterable) {
        return PandaStream.of(StreamSupport.stream(iterable.spliterator(), false));
    }

    @SafeVarargs
    public static <T> PandaStream<T> of(T ... array) {
        return PandaStream.of(Arrays.stream(array));
    }

    public static <T> PandaStream<T> empty() {
        return new PandaStream(Stream.empty());
    }
}

