/*
 * Decompiled with CFR 0.152.
 */
package panda.std.stream;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamUtils {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER;

    private StreamUtils() {
    }

    static <T> Class<T> convertPrimitiveToWrapper(Class<T> type) {
        return PRIMITIVE_TO_WRAPPER.getOrDefault(type, type);
    }

    public static <T> long sum(Iterable<T> iterable, ToLongFunction<? super T> function) {
        return StreamUtils.stream(iterable).mapToLong(function).sum();
    }

    public static <T> long sumLongs(Iterable<T> iterable, ToLongFunction<? super T> function) {
        return StreamUtils.stream(iterable).mapToLong(function).sum();
    }

    public static <T> long count(Iterable<T> iterable, Predicate<T> filter) {
        return StreamUtils.stream(iterable).filter(filter).count();
    }

    public static <T> Optional<T> findFirst(Iterable<T> iterable, Predicate<T> filter) {
        return StreamUtils.stream(iterable).filter(filter).findFirst();
    }

    public static <R, T> Collection<R> map(Iterable<T> iterable, Function<T, R> mapper) {
        return StreamUtils.stream(iterable).map(mapper).collect(Collectors.toList());
    }

    private static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> BinaryOperator<T> emptyBinaryOperator() {
        return (a, b) -> {
            throw new RuntimeException("Empty binary operator called by parallel stream");
        };
    }

    static {
        HashMap<Class<Object>, Class<Void>> primitiveToWrapper = new HashMap<Class<Object>, Class<Void>>();
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Character.TYPE, Character.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER = Collections.unmodifiableMap(primitiveToWrapper);
    }
}

