/*
 * Decompiled with CFR 0.152.
 */
package panda.std.reactive;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import panda.std.reactive.Publisher;
import panda.std.reactive.Subscriber;

public class Completable<VALUE>
implements Publisher<Completable<VALUE>, VALUE> {
    private VALUE value = null;
    private boolean ready;
    private List<Subscriber<? super VALUE>> subscribers = new ArrayList<Subscriber<? super VALUE>>(3);

    public static <VALUE> Completable<VALUE> completed(VALUE value) {
        return new Completable<VALUE>().complete(value);
    }

    public static <VALUE> Completable<VALUE> create() {
        return new Completable<VALUE>();
    }

    public boolean isReady() {
        return this.ready;
    }

    public boolean isUnprepared() {
        return !this.isReady();
    }

    public VALUE get() {
        if (this.isReady()) {
            return this.value;
        }
        throw new IllegalStateException("Option has not been completed");
    }

    public <ERROR extends Exception> VALUE orThrow(Supplier<ERROR> exception) throws ERROR {
        if (this.isReady()) {
            return this.value;
        }
        throw (Exception)exception.get();
    }

    @Override
    public Completable<VALUE> subscribe(Subscriber<? super VALUE> subscriber) {
        if (this.isReady()) {
            subscriber.onComplete(this.get());
        } else {
            this.subscribers.add(subscriber);
        }
        return this;
    }

    public Completable<VALUE> complete(VALUE value) {
        if (this.isReady()) {
            return this;
        }
        this.ready = true;
        this.value = Objects.requireNonNull(value);
        for (Subscriber<VALUE> subscriber : this.subscribers) {
            subscriber.onComplete(value);
        }
        this.subscribers = null;
        return this;
    }

    public Completable<VALUE> then(Consumer<? super VALUE> consumer) {
        this.subscribe(consumer::accept);
        return this;
    }

    public <R> Completable<R> thenApply(Function<? super VALUE, R> map) {
        Completable mappedOption = new Completable();
        this.subscribe((VALUE completedValue) -> mappedOption.complete(map.apply((Object)completedValue)));
        return mappedOption;
    }

    public <R> Completable<R> thenCompose(Function<? super VALUE, ? extends Completable<R>> map) {
        Completable mappedOption = new Completable();
        this.subscribe((VALUE completedValue) -> ((Completable)map.apply((Object)completedValue)).then(mappedOption::complete));
        return mappedOption;
    }

    public CompletableFuture<VALUE> toFuture() {
        CompletableFuture future = new CompletableFuture();
        this.then(future::complete);
        return future;
    }
}

