/*
 * Decompiled with CFR 0.152.
 */
package panda.std.stream;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import panda.std.Option;

final class TakeWhileSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> condition;
    private boolean conditionHolds;
    @Nullable
    private T holdValue;

    TakeWhileSpliterator(Spliterator<T> source, Predicate<T> condition) {
        this.source = source;
        this.condition = condition;
        this.conditionHolds = true;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        return this.conditionHolds && this.source.tryAdvance(element -> {
            if (this.condition.test(element)) {
                action.accept(element);
            } else {
                this.conditionHolds = false;
                this.holdValue = element;
            }
        });
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return 0L;
    }

    @Override
    public int characteristics() {
        return 0;
    }

    public Option<T> getHoldValue() {
        return Option.of(this.holdValue);
    }
}

