/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities;

import java.util.Arrays;
import java.util.Stack;
import java.util.function.Predicate;
import panda.std.stream.PandaStream;

public final class StackTraceUtils {
    private StackTraceUtils() {
    }

    public static StackTraceElement[] startsWith(StackTraceElement[] stackTrace, Predicate<StackTraceElement> condition) {
        return (StackTraceElement[])PandaStream.of((Object[])stackTrace).takeWhile(element -> !condition.test((StackTraceElement)element)).toArray(StackTraceElement[]::new);
    }

    public static StackTraceElement[] filter(StackTraceElement[] stackTrace, Class<?> ... ignored) {
        return StackTraceUtils.filter(stackTrace, (String[])Arrays.stream(ignored).map(Class::getName).toArray(String[]::new));
    }

    public static StackTraceElement[] filter(StackTraceElement[] stacktrace, String ... ignored) {
        return StackTraceUtils.filter(stacktrace, (StackTraceElement element) -> Arrays.stream(ignored).anyMatch(ignoredName -> element.getClassName().startsWith((String)ignoredName)));
    }

    private static StackTraceElement[] filter(StackTraceElement[] stacktrace, Predicate<StackTraceElement> filter) {
        Stack<StackTraceElement> filtered = new Stack<StackTraceElement>();
        for (StackTraceElement element : stacktrace) {
            if (filter.test(element)) continue;
            filtered.push(element);
        }
        return filtered.toArray(new StackTraceElement[0]);
    }
}

