/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities.iterable;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public final class ArrayIterable<T>
implements Iterable<T> {
    private final Object array;
    private final int length;

    public ArrayIterable(Object array) {
        this.array = array;
        this.length = Array.getLength(array);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    final class ArrayIterator
    implements Iterator<T> {
        private int index;

        ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < ArrayIterable.this.length;
        }

        @Override
        public T next() {
            return Array.get(ArrayIterable.this.array, this.index++);
        }
    }
}

