/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities.iterable;

import java.util.Arrays;
import java.util.Iterator;

public final class ResourcesIterable<T>
implements Iterable<T> {
    private final Iterable<? extends T>[] iterables;

    @SafeVarargs
    public ResourcesIterable(Iterable<? extends T> ... iterables) {
        if (iterables.length == 0) {
            throw new IllegalArgumentException("ResourcesIterable requires at least one resource");
        }
        this.iterables = iterables;
    }

    @Override
    public Iterator<T> iterator() {
        return new ResourceIterator();
    }

    final class ResourceIterator
    implements Iterator<T> {
        private final Iterator<? extends T>[] iterators;
        private int selected;

        public ResourceIterator() {
            this.iterators = (Iterator[])Arrays.stream(ResourcesIterable.this.iterables).map(Iterable::iterator).toArray(Iterator[]::new);
            this.selectNext();
        }

        @Override
        public boolean hasNext() {
            return this.iterators[this.selected].hasNext();
        }

        @Override
        public T next() {
            Object value = this.iterators[this.selected].next();
            if (!this.iterators[this.selected].hasNext()) {
                this.selectNext();
            }
            return value;
        }

        private void selectNext() {
            for (int i = this.selected; i < this.iterators.length; ++i) {
                Iterator iterator = this.iterators[i];
                if (!iterator.hasNext()) continue;
                this.selected = i;
                break;
            }
        }
    }
}

