/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities.collection;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Maps {
    private Maps() {
    }

    public static <K, V> void update(Map<K, V> map, K key, Supplier<V> defaultValue, Function<V, V> updateFunction) {
        Object value = map.computeIfAbsent(key, currentKey -> defaultValue.get());
        map.put(key, updateFunction.apply(value));
    }

    public static <K, V> V put(Map<? super K, ? super V> map, K key, V value) {
        map.put(key, value);
        return value;
    }

    public static <K, V> Map<V, K> swapped(Map<K, V> map, Supplier<Map<V, K>> mapSupplier) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (key, value) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", key));
        }, mapSupplier));
    }

    public static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    public static <K, V> Map.Entry<K, V> immutableEntryOf(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <K, V> Map<K, V> of(Object ... values) {
        return Maps.of(null, null, values);
    }

    public static <K, V> Map<K, V> of(Class<K> keyType, Class<V> valueType, Object ... values) {
        if (values.length % 2 != 0) {
            throw new IllegalArgumentException("The number of given values is not even");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < values.length; i += 2) {
            map.put(values[i], values[i + 1]);
        }
        return map;
    }
}

