/*
 * Decompiled with CFR 0.152.
 */
package panda.utilities.javassist;

import javassist.CannotCompileException;
import javassist.CtBehavior;
import panda.utilities.StringUtils;
import panda.utilities.text.Formatter;

public final class CtCode<T extends CtBehavior> {
    private final T behavior;
    private final Formatter formatter = new Formatter();

    private CtCode(T behavior) {
        this.behavior = behavior;
    }

    public CtCode<T> alias(String placeholder, String value) {
        this.formatter.register(placeholder, value);
        return this;
    }

    public T compile(String ... lines) throws CannotCompileException {
        this.behavior.setBody("{ " + this.formatter.format(StringUtils.join(lines)) + " }");
        return this.behavior;
    }

    public static <T extends CtBehavior> CtCode<T> of(T behavior) {
        return new CtCode<T>(behavior);
    }
}

