/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.reflect.Constructor;
import org.panda_lang.utilities.inject.InjectorCache;
import org.panda_lang.utilities.inject.InjectorProcessor;
import panda.utilities.ObjectUtils;

public final class ConstructorInjector<T> {
    private final InjectorProcessor processor;
    private final Constructor<?> constructor;
    private final InjectorCache cache;

    ConstructorInjector(InjectorProcessor processor, Constructor<T> constructor) {
        this.processor = processor;
        this.constructor = constructor;
        constructor.setAccessible(true);
        this.cache = InjectorCache.of(processor, constructor);
    }

    public T newInstance(Object ... injectorArgs) throws Exception {
        return (T)ObjectUtils.cast(this.constructor.newInstance(this.processor.fetchValues(this.cache, injectorArgs)));
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }
}

