/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.panda_lang.utilities.inject.Bind;
import org.panda_lang.utilities.inject.BindValue;
import org.panda_lang.utilities.inject.HandledBindValue;
import org.panda_lang.utilities.inject.Property;
import org.panda_lang.utilities.inject.StaticBindValue;
import panda.std.function.ThrowingSupplier;
import panda.std.function.ThrowingTriFunction;
import panda.std.function.TriFunction;
import panda.utilities.ObjectUtils;

class DefaultBind<A extends Annotation>
implements Bind<A> {
    private final Class<?> associatedType;
    private final Class<?> dataType;
    private BindValue<A> value;

    DefaultBind(Class<?> associatedType) {
        this(associatedType, associatedType);
    }

    DefaultBind(Class<?> associatedType, Class<?> dataType) {
        if (ObjectUtils.areNull((Object[])new Object[]{associatedType, dataType})) {
            throw new IllegalArgumentException("Associated type cannot be null at the same time");
        }
        this.associatedType = associatedType;
        this.dataType = dataType;
    }

    private void with(BindValue<A> value) {
        this.value = value;
    }

    @Override
    public void assignInstance(Object value) {
        this.with(new StaticBindValue(value));
    }

    @Override
    public void assignInstance(Supplier<?> valueSupplier) {
        this.with(new StaticBindValue(valueSupplier));
    }

    @Override
    public void assignThrowingInstance(ThrowingSupplier<?, ? extends Exception> valueSupplier) {
        this.with(new StaticBindValue(valueSupplier));
    }

    @Override
    public void assignHandler(TriFunction<Property, A, Object[], ?> handler) {
        this.with(new HandledBindValue<A>(handler));
    }

    @Override
    public void assignThrowingHandler(ThrowingTriFunction<Property, A, Object[], ?, ? extends Exception> handler) {
        this.with(new HandledBindValue<A>(handler));
    }

    @Override
    public Object getValue(Property required, A annotation, Object ... injectedArgs) throws Exception {
        return this.value.getValue(required, annotation, injectedArgs);
    }

    @Override
    public Class<?> getAssociatedType() {
        return this.associatedType;
    }

    @Override
    public Class<?> getDataType() {
        return this.dataType;
    }
}

