/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.InvalidParameterException;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.utilities.inject.ClassCache;
import org.panda_lang.utilities.inject.ConstructorInjector;
import org.panda_lang.utilities.inject.DefaultMethodInjector;
import org.panda_lang.utilities.inject.DependencyInjection;
import org.panda_lang.utilities.inject.DependencyInjectionException;
import org.panda_lang.utilities.inject.FieldsInjector;
import org.panda_lang.utilities.inject.Injector;
import org.panda_lang.utilities.inject.InjectorController;
import org.panda_lang.utilities.inject.InjectorProcessor;
import org.panda_lang.utilities.inject.MethodInjector;
import org.panda_lang.utilities.inject.MethodInjectorFactory;
import org.panda_lang.utilities.inject.PropertyParameter;
import org.panda_lang.utilities.inject.Resources;
import org.panda_lang.utilities.inject.annotations.PostConstruct;
import panda.std.Lazy;
import panda.utilities.ObjectUtils;

final class DefaultInjector
implements Injector {
    private final Resources resources;
    private final InjectorProcessor processor;
    private final Lazy<MethodInjectorFactory> methodInjectorFactory = new Lazy(() -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(ServiceLoader.load(MethodInjectorFactory.class).iterator(), 16), false).findAny().orElseGet(() -> (processor, method) -> this.forMethod(method)));

    public DefaultInjector(Resources resources) {
        this.resources = resources;
        this.processor = new InjectorProcessor(this);
    }

    @Override
    public <T> ConstructorInjector<T> forConstructor(Class<T> type) {
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        if (constructors.length != 1) {
            throw new InvalidParameterException("Class has to contain one and only constructor");
        }
        return new ConstructorInjector(this.processor, constructors[0]);
    }

    @Override
    public <T> ConstructorInjector<T> forConstructor(Constructor<T> constructor) {
        return new ConstructorInjector<T>(this.processor, constructor);
    }

    @Override
    public <T> FieldsInjector<T> forFields(Class<T> type) {
        return new FieldsInjector<T>(this.processor, this.forConstructor(type));
    }

    @Override
    public <T> FieldsInjector<T> forFields(Constructor<T> constructor) {
        return new FieldsInjector<T>(this.processor, this.forConstructor(constructor));
    }

    @Override
    public <T> T newInstance(Class<T> type, Object ... injectorArgs) throws DependencyInjectionException {
        try {
            T instance = this.forConstructor(type).newInstance(injectorArgs);
            this.invokeAnnotatedMethods(PostConstruct.class, instance, injectorArgs);
            return instance;
        }
        catch (Exception exception) {
            throw new DependencyInjectionException("Cannot create instance of " + type.getSimpleName(), exception);
        }
    }

    @Override
    public <T> T newInstance(Constructor<T> constructor, Object ... injectorArgs) throws DependencyInjectionException {
        try {
            T instance = this.forConstructor(constructor).newInstance(injectorArgs);
            this.invokeAnnotatedMethods(PostConstruct.class, instance, injectorArgs);
            return instance;
        }
        catch (Exception exception) {
            throw new DependencyInjectionException("Cannot create instance of " + constructor.getDeclaringClass().getSimpleName(), exception);
        }
    }

    @Override
    public <T> T newInstanceWithFields(Class<T> type, Object ... injectorArgs) throws DependencyInjectionException {
        try {
            T instance = this.forFields(type).newInstance(injectorArgs);
            this.invokeAnnotatedMethods(PostConstruct.class, instance, injectorArgs);
            return instance;
        }
        catch (Exception exception) {
            throw new DependencyInjectionException("Cannot create instance of " + type.getSimpleName(), exception);
        }
    }

    @Override
    public <T> T newInstanceWithFields(Constructor<T> constructor, Object ... injectorArgs) throws DependencyInjectionException {
        try {
            T instance = this.forFields(constructor).newInstance(injectorArgs);
            this.invokeAnnotatedMethods(PostConstruct.class, instance, injectorArgs);
            return instance;
        }
        catch (Exception exception) {
            throw new DependencyInjectionException("Cannot create instance of " + constructor.getDeclaringClass().getSimpleName(), exception);
        }
    }

    @Override
    public MethodInjector forMethod(Method method) {
        return new DefaultMethodInjector(this.processor, method);
    }

    @Override
    public MethodInjector forGeneratedMethod(Method method) throws Exception {
        return ((MethodInjectorFactory)this.methodInjectorFactory.get()).createMethodInjector(this.processor, method);
    }

    @Override
    public <T> T invokeMethod(Method method, Object instance, Object ... injectorArgs) throws DependencyInjectionException {
        try {
            return this.forMethod(method).invoke(instance, injectorArgs);
        }
        catch (Exception exception) {
            throw new DependencyInjectionException("Cannot invoke method " + method.getName() + " of " + instance.getClass().getSimpleName(), exception);
        }
    }

    @Override
    public void invokeAnnotatedMethods(Class<? extends Annotation> annotation, Object instance, Object ... injectorArgs) throws DependencyInjectionException {
        for (Method method : ClassCache.getAnnotatedMethods(instance.getClass(), annotation)) {
            this.invokeMethod(method, instance, injectorArgs);
        }
    }

    @Override
    @Nullable
    public <T> T invokeParameter(Parameter parameter, Object ... injectorArgs) throws Exception {
        return (T)ObjectUtils.cast((Object)this.processor.fetchValue(new PropertyParameter(parameter), injectorArgs));
    }

    @Override
    public Injector fork(InjectorController controller) {
        return DependencyInjection.INJECTOR_FACTORY.createInjector(controller, this.resources.fork());
    }

    @Override
    public Injector duplicate(InjectorController controller) {
        return DependencyInjection.INJECTOR_FACTORY.createInjector(controller, this.resources.duplicate());
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }
}

