/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.reflect.Method;
import org.panda_lang.utilities.inject.InjectorCache;
import org.panda_lang.utilities.inject.InjectorProcessor;
import org.panda_lang.utilities.inject.MethodInjector;
import panda.utilities.ObjectUtils;

public final class DefaultMethodInjector
implements MethodInjector {
    private final InjectorProcessor processor;
    private final Method method;
    private final InjectorCache cache;

    DefaultMethodInjector(InjectorProcessor processor, Method method) {
        this.processor = processor;
        this.method = method;
        method.setAccessible(true);
        this.cache = InjectorCache.of(processor, method);
    }

    @Override
    public <T> T invoke(Object instance, Object ... injectorArgs) throws Exception {
        return (T)ObjectUtils.cast((Object)this.method.invoke(instance, this.processor.fetchValues(this.cache, injectorArgs)));
    }

    @Override
    public Method getMethod() {
        return this.method;
    }
}

