/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.utilities.inject.Bind;
import org.panda_lang.utilities.inject.BindHandler;
import org.panda_lang.utilities.inject.DefaultBind;
import org.panda_lang.utilities.inject.DefaultBindHandler;
import org.panda_lang.utilities.inject.Property;
import org.panda_lang.utilities.inject.Resources;
import panda.std.Option;
import panda.std.function.ThrowingQuadFunction;
import panda.std.function.ThrowingTriFunction;
import panda.utilities.ArrayUtils;
import panda.utilities.ClassUtils;
import panda.utilities.ObjectUtils;

final class DefaultResources
implements Resources {
    private final Option<Resources> parent;
    private final Map<Class<?>, Bind<Annotation>> binds;
    private final Map<HandlerRecord, BindHandler<Annotation, Object, ?>> handlers;
    private final Map<Executable, Annotation[][]> cachedAnnotations;

    DefaultResources(@Nullable Resources parent, Map<Class<?>, Bind<Annotation>> resources, Map<HandlerRecord, BindHandler<Annotation, Object, ?>> handlers, Map<Executable, Annotation[][]> cachedAnnotations) {
        this.parent = Option.of((Object)parent);
        this.binds = new HashMap(resources);
        this.handlers = new HashMap(handlers);
        this.cachedAnnotations = new HashMap<Executable, Annotation[][]>(cachedAnnotations);
    }

    DefaultResources() {
        this(null, new HashMap(), new HashMap(), new HashMap<Executable, Annotation[][]>());
    }

    private <A extends Annotation> Bind<A> with(Bind<A> bind) {
        this.binds.put(bind.getAssociatedType(), (Bind)ObjectUtils.cast(bind));
        return bind;
    }

    public Bind<Annotation> on(Class<?> type) {
        return this.with(new DefaultBind(type));
    }

    @Override
    public <A extends Annotation> Bind<A> annotatedWith(Class<A> annotation) {
        return this.with(new DefaultBind(annotation));
    }

    @Override
    public <V, R, E extends Exception> void processType(Class<V> associatedType, ThrowingTriFunction<Property, V, Object[], R, E> processor) {
        this.with(new HandlerRecord(associatedType, null), new DefaultBindHandler(null, processor));
    }

    @Override
    public <A extends Annotation, V, R, E extends Exception> void processAnnotated(Class<A> annotationType, ThrowingQuadFunction<A, Property, V, Object[], R, E> processor) {
        this.with(new HandlerRecord(null, annotationType), new DefaultBindHandler<A, V, R, E>(annotationType, processor));
    }

    @Override
    public <A extends Annotation, V, R, E extends Exception> void processAnnotatedType(Class<A> annotationType, Class<V> type, ThrowingQuadFunction<A, Property, V, Object[], R, E> processor) {
        this.with(new HandlerRecord(type, annotationType), new DefaultBindHandler<A, V, R, E>(annotationType, processor));
    }

    private <A extends Annotation, V, R, E extends Exception> void with(HandlerRecord record, DefaultBindHandler<A, V, R, E> handler) {
        this.handlers.put(record, (BindHandler)ObjectUtils.cast(handler));
    }

    @Override
    public Annotation[] fetchAnnotations(Parameter parameter) {
        Annotation[][] parameterAnnotations = this.fetchAnnotations(parameter.getDeclaringExecutable());
        int index = ArrayUtils.indexOf((Object[])parameter.getDeclaringExecutable().getParameters(), (Object)parameter);
        return parameterAnnotations[index];
    }

    @Override
    public Annotation[][] fetchAnnotations(Executable executable) {
        Annotation[][] parameterAnnotations = this.cachedAnnotations.get(executable);
        if (parameterAnnotations == null) {
            parameterAnnotations = executable.getParameterAnnotations();
            this.cachedAnnotations.put(executable, parameterAnnotations);
        }
        return parameterAnnotations;
    }

    @Override
    public Collection<BindHandler<Annotation, Object, ?>> getHandler(Parameter parameter) {
        Executable executable = parameter.getDeclaringExecutable();
        Annotation[] annotations = this.fetchAnnotations(parameter);
        ArrayList matched = new ArrayList(executable.getParameterCount());
        this.add(matched, new HandlerRecord(parameter.getType(), null));
        for (Annotation annotation : annotations) {
            this.add(matched, new HandlerRecord(parameter.getType(), null));
            this.add(matched, new HandlerRecord(parameter.getType(), annotation.annotationType()));
            this.add(matched, new HandlerRecord(null, annotation.annotationType()));
        }
        return matched;
    }

    private void add(Collection<BindHandler<Annotation, Object, ?>> matched, HandlerRecord record) {
        BindHandler<Annotation, Object, ?> handler = this.handlers.get(record);
        if (handler != null) {
            matched.add(handler);
        }
    }

    @Override
    public Option<Bind<Annotation>> getBind(Class<?> requestedType) {
        Option mostRelated = ClassUtils.selectMostRelated(this.binds.keySet(), requestedType).map(this.binds::get);
        if (mostRelated.isPresent()) {
            return mostRelated;
        }
        List associated = this.binds.keySet().stream().filter(requestedType::isAssignableFrom).map(this.binds::get).collect(Collectors.toList());
        if (associated.size() == 1) {
            return Option.of((Object)((Bind)associated.get(0)));
        }
        return this.parent.flatMap(parent -> parent.getBind(requestedType));
    }

    @Override
    public Resources fork() {
        return new DefaultResources(this, new HashMap(), new HashMap(), new HashMap<Executable, Annotation[][]>());
    }

    @Override
    public Resources duplicate() {
        return new DefaultResources(null, this.binds, this.handlers, this.cachedAnnotations);
    }

    private static final class HandlerRecord {
        private final Class<?> type;
        private Class<? extends Annotation> annotation;

        private HandlerRecord(@Nullable Class<?> type, @Nullable Class<? extends Annotation> annotation) {
            if (type == null && annotation == null) {
                throw new IllegalArgumentException("You have to provide at least type or annotation");
            }
            this.type = type;
            this.annotation = annotation;
        }

        private void setAnnotation(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerRecord that = (HandlerRecord)o;
            return Objects.equals(this.annotation, that.annotation) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            int result = this.annotation != null ? this.annotation.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}

