/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.panda_lang.utilities.inject.DependencyInjectionException;
import org.panda_lang.utilities.inject.annotations.Injectable;

public final class DependencyInjectionUtils {
    private DependencyInjectionUtils() {
    }

    public static <T> Class<T> testAnnotation(Class<T> annotation) throws DependencyInjectionException {
        if (!annotation.isAnnotation()) {
            throw new DependencyInjectionException(annotation + " is not an annotation");
        }
        Retention retention = annotation.getAnnotation(Retention.class);
        if (retention == null) {
            throw new DependencyInjectionException(annotation + " has no specified retention policy");
        }
        if (retention.value() != RetentionPolicy.RUNTIME) {
            throw new DependencyInjectionException(annotation + " is not marked as runtime annotation");
        }
        if (annotation.getAnnotation(Injectable.class) == null) {
            throw new DependencyInjectionException(annotation + " is not marked as @Injectable");
        }
        return annotation;
    }
}

