/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.panda_lang.utilities.inject.Bind;
import org.panda_lang.utilities.inject.BindHandler;
import org.panda_lang.utilities.inject.InjectorProcessor;
import org.panda_lang.utilities.inject.Property;
import org.panda_lang.utilities.inject.annotations.Injectable;
import panda.utilities.ArrayUtils;

final class InjectorCache {
    private final Property[] properties;
    private final Annotation[] injectable;
    private final Map<Class<? extends Annotation>, Annotation>[] annotations;
    private final Bind<Annotation>[] binds;
    private final Collection<BindHandler<Annotation, Object, ?>>[] handlers;

    private InjectorCache(Property[] properties, Annotation[] injectable, Map<Class<? extends Annotation>, Annotation>[] annotations, Bind<Annotation>[] binds, Collection<BindHandler<Annotation, Object, ?>>[] handlers) {
        this.properties = properties;
        this.injectable = injectable;
        this.annotations = annotations;
        this.binds = binds;
        this.handlers = handlers;
    }

    Annotation[] getInjectable() {
        return this.injectable;
    }

    Map<Class<? extends Annotation>, Annotation>[] getAnnotations() {
        return this.annotations;
    }

    Bind<Annotation>[] getBinds() {
        return this.binds;
    }

    Collection<BindHandler<Annotation, Object, ?>>[] getHandlers() {
        return this.handlers;
    }

    Property[] getProperties() {
        return this.properties;
    }

    public static InjectorCache of(InjectorProcessor processor, Executable executable) {
        Annotation[] injectable = processor.fetchAnnotations(executable);
        return new InjectorCache(processor.fetchInjectorProperties(executable.getParameters()), injectable, processor.fetchAnnotationsMap(executable), processor.fetchBinds(injectable, executable), processor.fetchHandlers(executable));
    }

    public static InjectorCache of(InjectorProcessor processor, Property property) {
        Annotation annotation = (Annotation)ArrayUtils.findIn((Object[])property.getAnnotations(), a -> a.annotationType().isAnnotationPresent(Injectable.class)).orNull();
        return new InjectorCache((Property[])ArrayUtils.of((Object[])new Property[]{property}), (Annotation[])ArrayUtils.of((Object[])new Annotation[]{annotation}), (Map[])ArrayUtils.of((Object[])new Map[]{Collections.emptyMap()}), (Bind[])ArrayUtils.of((Object[])new Bind[]{processor.fetchBind(annotation, property)}), (Collection[])ArrayUtils.of((Object[])new List[]{Collections.emptyList()}));
    }
}

