/*
 * Decompiled with CFR 0.152.
 */
package org.panda_lang.utilities.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.panda_lang.utilities.inject.Bind;
import org.panda_lang.utilities.inject.BindHandler;
import org.panda_lang.utilities.inject.DefaultBind;
import org.panda_lang.utilities.inject.Injector;
import org.panda_lang.utilities.inject.InjectorCache;
import org.panda_lang.utilities.inject.MissingBindException;
import org.panda_lang.utilities.inject.Property;
import org.panda_lang.utilities.inject.PropertyParameter;
import org.panda_lang.utilities.inject.Resources;
import org.panda_lang.utilities.inject.annotations.AutoConstruct;
import org.panda_lang.utilities.inject.annotations.Injectable;
import panda.utilities.ObjectUtils;
import panda.utilities.text.Joiner;

final class InjectorProcessor {
    private final Injector injector;
    private final Map<Executable, Annotation[]> injectableCache = new HashMap<Executable, Annotation[]>();
    private final Bind<Annotation> autoConstructBind;

    InjectorProcessor(Injector injector) {
        this.injector = injector;
        this.autoConstructBind = new DefaultBind<Annotation>(AutoConstruct.class);
        this.autoConstructBind.assignThrowingHandler((property, annotation, injectorArgs) -> injector.newInstanceWithFields(property.getType(), injectorArgs));
    }

    protected Object[] fetchValues(InjectorCache cache, Object ... injectorArgs) throws Exception {
        Property[] properties = cache.getProperties();
        Object[] values = new Object[cache.getInjectable().length];
        for (int index = 0; index < values.length; ++index) {
            values[index] = this.fetchValue(cache, properties[index], index, injectorArgs);
        }
        return values;
    }

    @Nullable
    protected Object fetchValue(Property property, Object ... injectorArgs) throws Exception {
        InjectorCache cache = InjectorCache.of(this, property);
        return this.fetchValue(cache, property, 0, injectorArgs);
    }

    @Nullable
    private Object fetchValue(InjectorCache cache, Property property, int index, Object ... injectorArgs) throws Exception {
        Object value = cache.getBinds()[index].getValue(property, cache.getInjectable()[index], injectorArgs);
        for (BindHandler<Annotation, Object, ?> handler : cache.getHandlers()[index]) {
            Annotation annotation = null;
            if (handler.getAnnotation().isPresent()) {
                annotation = cache.getAnnotations()[index].get(handler.getAnnotation().get());
            }
            value = handler.process(property, annotation, ObjectUtils.cast((Object)value), injectorArgs);
        }
        return value;
    }

    protected Property[] fetchInjectorProperties(Parameter[] parameters) {
        Property[] properties = new Property[parameters.length];
        for (int index = 0; index < parameters.length; ++index) {
            properties[index] = new PropertyParameter(parameters[index]);
        }
        return properties;
    }

    protected Annotation[] fetchAnnotations(Executable executable) {
        Annotation[] injectorAnnotations = this.injectableCache.get(executable);
        if (injectorAnnotations != null) {
            return injectorAnnotations;
        }
        injectorAnnotations = new Annotation[executable.getParameterTypes().length];
        Annotation[][] parameterAnnotations = this.injector.getResources().fetchAnnotations(executable);
        for (int index = 0; index < parameterAnnotations.length; ++index) {
            for (Annotation annotation : parameterAnnotations[index]) {
                if (!annotation.annotationType().isAnnotationPresent(Injectable.class)) continue;
                injectorAnnotations[index] = annotation;
            }
        }
        this.injectableCache.put(executable, injectorAnnotations);
        return injectorAnnotations;
    }

    protected Map<Class<? extends Annotation>, Annotation>[] fetchAnnotationsMap(Executable executable) {
        Annotation[][] annotations = this.injector.getResources().fetchAnnotations(executable);
        Map[] mappedAnnotations = (Map[])ObjectUtils.cast((Object)new HashMap[annotations.length]);
        for (int index = 0; index < annotations.length; ++index) {
            HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
            for (Annotation annotation : annotations[index]) {
                annotationMap.put(annotation.annotationType(), annotation);
            }
            mappedAnnotations[index] = annotationMap;
        }
        return mappedAnnotations;
    }

    protected Bind<Annotation>[] fetchBinds(Annotation[] annotations, Executable executable) throws MissingBindException {
        Resources resources = this.injector.getResources();
        Parameter[] parameters = executable.getParameters();
        Bind[] binds = (Bind[])ObjectUtils.cast((Object)new Bind[parameters.length]);
        for (int index = 0; index < annotations.length; ++index) {
            Bind<Annotation> bind;
            Annotation annotation = annotations[index];
            Parameter parameter = parameters[index];
            Bind<Annotation> bind2 = bind = annotation != null ? (Bind<Annotation>)this.injector.getResources().getBind(annotation.annotationType()).orNull() : null;
            if (bind == null) {
                bind = (Bind)this.injector.getResources().getBind(parameter.getType()).orNull();
            }
            if (bind == null && parameter.getAnnotation(AutoConstruct.class) != null) {
                bind = this.autoConstructBind;
            }
            if (bind == null) {
                String simplifiedParameters = Joiner.on((String)", ").join((Collection)Arrays.stream(executable.getParameters()).map(p -> p.getType().getSimpleName() + " " + p.getName()).collect(Collectors.toList())).toString();
                throw new MissingBindException("Cannot find proper bind" + System.lineSeparator() + "    missing bind for parameter: " + parameter.getType().getSimpleName() + " " + parameter.getName() + System.lineSeparator() + "    in executable: " + executable.getDeclaringClass().getSimpleName() + "#" + executable.getName() + "(" + simplifiedParameters + ")" + System.lineSeparator());
            }
            binds[index] = bind;
        }
        return binds;
    }

    protected Bind<Annotation> fetchBind(@Nullable Annotation annotation, Property property) throws MissingBindException {
        Bind<Annotation> bind;
        Bind<Annotation> bind2 = bind = annotation != null ? (Bind<Annotation>)this.injector.getResources().getBind(annotation.annotationType()).orNull() : null;
        if (bind == null) {
            bind = (Bind)this.injector.getResources().getBind(property.getType()).orNull();
        }
        if (bind == null && property.getAnnotation(AutoConstruct.class) != null) {
            bind = this.autoConstructBind;
        }
        if (bind == null) {
            throw new MissingBindException("Cannot find proper bind for property: " + property.getType().getSimpleName() + " " + property.getName());
        }
        return bind;
    }

    protected Collection<BindHandler<Annotation, Object, ?>>[] fetchHandlers(Executable executable) {
        Collection[] handlers = (Collection[])ObjectUtils.cast((Object)new Collection[executable.getParameterCount()]);
        Parameter[] parameters = executable.getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            handlers[index] = this.injector.getResources().getHandler(parameters[index]);
        }
        return handlers;
    }

    Bind<Annotation> getAutoConstructBind() {
        return this.autoConstructBind;
    }
}

