/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.panteleyev.jpackage.EnumParameter;
import org.panteleyev.jpackage.ImageType;
import org.panteleyev.jpackage.Launcher;
import org.panteleyev.jpackage.OsUtil;
import org.panteleyev.jpackage.StringUtil;

@Mojo(name="jpackage", defaultPhase=LifecyclePhase.NONE)
public class JPackageMojo
extends AbstractMojo {
    public static final String GOAL = "jpackage";
    private static final String JPACKAGE_HOME_ENV = "JPACKAGE_HOME";
    private static final String TOOLCHAIN = "jdk";
    private static final String EXECUTABLE = "jpackage";
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private boolean verbose;
    @Parameter
    private ImageType type;
    @Parameter(required=true)
    private String name;
    @Parameter(defaultValue="${project.version}")
    private String appVersion;
    @Parameter
    private String vendor;
    @Parameter
    private String icon;
    @Parameter
    private String runtimeImage;
    @Parameter
    private String input;
    @Parameter
    private String installDir;
    @Parameter
    private String resourceDir;
    @Parameter(required=true)
    private String destination;
    @Parameter
    private String module;
    @Parameter
    private String mainClass;
    @Parameter
    private String mainJar;
    @Parameter
    private String temp;
    @Parameter
    private String copyright;
    @Parameter
    private String description;
    @Parameter
    private String modulePath;
    @Parameter
    private String[] javaOptions;
    @Parameter
    private String[] arguments;
    @Parameter
    private String licenseFile;
    @Parameter
    private String[] fileAssociations;
    @Parameter
    private Launcher[] launchers;
    @Parameter
    private boolean winMenu;
    @Parameter
    private boolean winDirChooser;
    @Parameter
    private String winUpgradeUuid;
    @Parameter
    private String winMenuGroup;
    @Parameter
    private boolean winShortcut;
    @Parameter
    private boolean winPerUserInstall;
    @Parameter
    private boolean winConsole;
    @Parameter
    private String macPackageIdentifier;
    @Parameter
    private String macPackageName;
    @Parameter
    private String macPackageSigningPrefix;
    @Parameter
    private boolean macSign;
    @Parameter
    private String macSigningKeychain;
    @Parameter
    private String macSigningKeyUserName;
    @Parameter
    private String linuxPackageName;
    @Parameter
    private String linuxDebMaintainer;
    @Parameter
    private String linuxMenuGroup;
    @Parameter
    private String linuxRpmLicenseType;
    @Parameter
    private String linuxAppRelease;
    @Parameter
    private String linuxAppCategory;
    @Parameter
    private boolean linuxShortcut;

    public void execute() throws MojoExecutionException {
        String executable = this.getJPackageExecutable();
        if (executable == null) {
            throw new MojoExecutionException("Failed to find jpackage");
        }
        this.getLog().info((CharSequence)("Using: " + executable));
        try {
            this.execute(executable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new MojoExecutionException(ex.getMessage());
        }
    }

    private String getJPackageFromJdkHome(String jdkHome) {
        if (jdkHome == null || jdkHome.isEmpty()) {
            return null;
        }
        this.getLog().info((CharSequence)("Looking for jpackage in " + jdkHome));
        String executable = jdkHome + File.separator + "bin" + File.separator + "jpackage";
        if (OsUtil.isWindows()) {
            executable = executable + ".exe";
        }
        if (new File(executable).exists()) {
            return executable;
        }
        this.getLog().warn((CharSequence)("File " + executable + " does not exist"));
        return null;
    }

    private String getJPackageFromToolchain() {
        this.getLog().info((CharSequence)"Looking for jpackage in toolchain");
        Toolchain jdk = this.toolchainManager.getToolchainFromBuildContext(TOOLCHAIN, this.session);
        if (jdk == null) {
            this.getLog().warn((CharSequence)"Toolchain not configured");
            return null;
        }
        String executable = jdk.findTool("jpackage");
        if (executable == null) {
            this.getLog().warn((CharSequence)"jpackage is not part of configured toolchain");
            return null;
        }
        return executable;
    }

    private String getJPackageExecutable() {
        String executable = this.getJPackageFromJdkHome(System.getenv(JPACKAGE_HOME_ENV));
        if (executable != null) {
            return executable;
        }
        executable = this.getJPackageFromToolchain();
        if (executable != null) {
            return executable;
        }
        return this.getJPackageFromJdkHome(System.getProperty("java.home"));
    }

    private void execute(String cmd) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(cmd.contains(" ") ? "\"" + cmd + "\"" : cmd);
        this.buildParameters(parameters);
        processBuilder.command(parameters);
        Process process = processBuilder.start();
        this.getLog().info((CharSequence)"jpackage output:");
        int status = process.waitFor();
        this.logCmdOutput(process.getInputStream());
        this.logCmdOutput(process.getErrorStream());
        if (status != 0) {
            throw new MojoExecutionException("Error while executing jpackage");
        }
    }

    private void buildParameters(List<String> parameters) {
        this.getLog().info((CharSequence)"jpackage parameters:");
        this.addParameter(parameters, "--verbose", this.verbose);
        this.addParameter(parameters, "--type", this.type);
        this.addParameter(parameters, "--name", this.name);
        this.addParameter(parameters, "--app-version", this.appVersion);
        this.addPathParameter(parameters, "--dest", this.destination);
        this.addParameter(parameters, "--copyright", this.copyright);
        this.addParameter(parameters, "--description", this.description);
        this.addPathParameter(parameters, "--runtime-image", this.runtimeImage);
        this.addPathParameter(parameters, "--input", this.input);
        this.addPathParameter(parameters, "--install-dir", this.installDir);
        this.addPathParameter(parameters, "--resource-dir", this.resourceDir);
        this.addParameter(parameters, "--vendor", this.vendor);
        this.addParameter(parameters, "--module", this.module);
        this.addParameter(parameters, "--main-class", this.mainClass);
        this.addParameter(parameters, "--main-jar", this.mainJar);
        this.addPathParameter(parameters, "--temp", this.temp);
        this.addPathParameter(parameters, "--module-path", this.modulePath);
        this.addPathParameter(parameters, "--icon", this.icon);
        this.addPathParameter(parameters, "--license-file", this.licenseFile);
        if (this.javaOptions != null) {
            for (String option : this.javaOptions) {
                this.addParameter(parameters, "--java-options", StringUtil.escape(option));
            }
        }
        if (this.arguments != null) {
            for (String arg : this.arguments) {
                this.addParameter(parameters, "--arguments", StringUtil.escape(arg));
            }
        }
        if (this.fileAssociations != null) {
            for (String association : this.fileAssociations) {
                this.addPathParameter(parameters, "--file-associations", association);
            }
        }
        if (this.launchers != null) {
            for (Launcher launcher : this.launchers) {
                this.addParameter(parameters, "--add-launcher", launcher.getName() + "=" + this.resolvePath(launcher.getFile()));
            }
        }
        if (OsUtil.isMac()) {
            this.addParameter(parameters, "--mac-package-identifier", this.macPackageIdentifier);
            this.addParameter(parameters, "--mac-package-name", this.macPackageName);
            this.addParameter(parameters, "--mac-package-signing-prefix", this.macPackageSigningPrefix);
            this.addParameter(parameters, "--mac-sign", this.macSign);
            this.addParameter(parameters, "--mac-signing-keychain", this.macSigningKeychain);
            this.addParameter(parameters, "--mac-signing-key-user-name", this.macSigningKeyUserName);
        } else if (OsUtil.isWindows()) {
            this.addParameter(parameters, "--win-menu", this.winMenu);
            this.addParameter(parameters, "--win-dir-chooser", this.winDirChooser);
            this.addParameter(parameters, "--win-upgrade-uuid", this.winUpgradeUuid);
            this.addParameter(parameters, "--win-menu-group", this.winMenuGroup);
            this.addParameter(parameters, "--win-shortcut", this.winShortcut);
            this.addParameter(parameters, "--win-per-user-install", this.winPerUserInstall);
            this.addParameter(parameters, "--win-console", this.winConsole);
        } else if (OsUtil.isLinux()) {
            this.addParameter(parameters, "--linux-package-name", this.linuxPackageName);
            this.addParameter(parameters, "--linux-deb-maintainer", this.linuxDebMaintainer);
            this.addParameter(parameters, "--linux-menu-group", this.linuxMenuGroup);
            this.addParameter(parameters, "--linux-rpm-license-type", this.linuxRpmLicenseType);
            this.addParameter(parameters, "--linux-app-release", this.linuxAppRelease);
            this.addParameter(parameters, "--linux-app-category", this.linuxAppCategory);
            this.addParameter(parameters, "--linux-shortcut", this.linuxShortcut);
        }
    }

    private void addParameter(List<String> params, String name, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name + " " + value));
        params.add(name);
        params.add(value);
    }

    private void addPathParameter(List<String> params, String name, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.addParameter(params, name, this.resolvePath(value));
    }

    private String resolvePath(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        Path path = new File(value).toPath();
        if (!path.isAbsolute()) {
            String oldValue = value;
            value = this.project.getBasedir().getAbsolutePath() + File.separator + value;
            this.getLog().debug((CharSequence)("Resolving path " + oldValue + " to " + value));
        }
        return value;
    }

    private void addParameter(List<String> params, String name, boolean value) {
        if (!value) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name));
        params.add(name);
    }

    private void addParameter(List<String> params, String name, EnumParameter value) {
        if (value == null) {
            return;
        }
        this.addParameter(params, name, value.getValue());
    }

    private void logCmdOutput(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.getLog().info((CharSequence)line);
            }
        }
    }
}

