/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.panteleyev.jpackage.EnumParameter;
import org.panteleyev.jpackage.ImageType;
import org.panteleyev.jpackage.Launcher;
import org.panteleyev.jpackage.OsUtil;
import org.panteleyev.jpackage.StringUtil;

@Mojo(name="jpackage", defaultPhase=LifecyclePhase.NONE)
public class JPackageMojo
extends AbstractMojo {
    public static final String GOAL = "jpackage";
    private static final String TOOLCHAIN = "jdk";
    private static final String EXECUTABLE = "jpackage";
    private static final String DRY_RUN_PROPERTY = "jpackage.dryRun";
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter
    private boolean verbose;
    @Parameter
    private ImageType type;
    @Parameter(defaultValue="${project.name}")
    private String name;
    @Parameter(defaultValue="${project.version}")
    private String appVersion;
    @Parameter
    private String vendor;
    @Parameter
    private File icon;
    @Parameter
    private File runtimeImage;
    @Parameter
    private File input;
    @Parameter
    private File installDir;
    @Parameter
    private File resourceDir;
    @Parameter
    private File destination;
    @Parameter
    private String module;
    @Parameter
    private String mainClass;
    @Parameter
    private String mainJar;
    @Parameter
    private File temp;
    @Parameter
    private String copyright;
    @Parameter
    private String description;
    @Parameter
    private List<File> modulePaths;
    @Parameter
    private List<String> javaOptions;
    @Parameter
    private List<String> arguments;
    @Parameter
    private File licenseFile;
    @Parameter
    private List<File> fileAssociations;
    @Parameter
    private List<Launcher> launchers;
    @Parameter
    private List<String> addModules;
    @Parameter
    private File appImage;
    @Parameter
    private List<String> additionalOptions;
    @Parameter
    private boolean winMenu;
    @Parameter
    private boolean winDirChooser;
    @Parameter
    private String winUpgradeUuid;
    @Parameter
    private String winMenuGroup;
    @Parameter
    private boolean winShortcut;
    @Parameter
    private boolean winPerUserInstall;
    @Parameter
    private boolean winConsole;
    @Parameter
    private String macPackageIdentifier;
    @Parameter
    private String macPackageName;
    @Parameter
    private String macPackageSigningPrefix;
    @Parameter
    private boolean macSign;
    @Parameter
    private File macSigningKeychain;
    @Parameter
    private String macSigningKeyUserName;
    @Parameter
    private String linuxPackageName;
    @Parameter
    private String linuxDebMaintainer;
    @Parameter
    private String linuxMenuGroup;
    @Parameter
    private String linuxRpmLicenseType;
    @Parameter
    private String linuxAppRelease;
    @Parameter
    private String linuxAppCategory;
    @Parameter
    private boolean linuxShortcut;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext(TOOLCHAIN, this.session);
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in jpackage-maven-plugin: " + tc));
        }
        String executable = this.getJPackageExecutable(tc).orElseThrow(() -> new MojoExecutionException("Failed to find jpackage"));
        this.getLog().info((CharSequence)("Using: " + executable));
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(executable.contains(" ") ? "\"" + executable + "\"" : executable);
        this.buildParameters(parameters);
        boolean dryRun = "true".equalsIgnoreCase(System.getProperty(DRY_RUN_PROPERTY, "false"));
        if (dryRun) {
            this.getLog().warn((CharSequence)"Dry-run mode, not executing jpackage");
        } else {
            try {
                this.execute(parameters);
            }
            catch (Exception ex) {
                throw new MojoExecutionException(ex.getMessage(), ex);
            }
        }
    }

    private Optional<String> getJPackageFromJdkHome(String jdkHome) {
        if (jdkHome == null || jdkHome.isEmpty()) {
            return Optional.empty();
        }
        this.getLog().debug((CharSequence)("Looking for jpackage in " + jdkHome));
        String executable = jdkHome + File.separator + "bin" + File.separator + "jpackage";
        if (OsUtil.isWindows()) {
            executable = executable + ".exe";
        }
        if (new File(executable).exists()) {
            return Optional.of(executable);
        }
        this.getLog().warn((CharSequence)("File " + executable + " does not exist"));
        return Optional.empty();
    }

    private Optional<String> getJPackageFromToolchain(Toolchain tc) {
        if (tc == null) {
            return Optional.empty();
        }
        String executable = tc.findTool("jpackage");
        if (executable == null) {
            this.getLog().warn((CharSequence)"jpackage is not part of configured toolchain");
        }
        return Optional.ofNullable(executable);
    }

    private Optional<String> getJPackageExecutable(Toolchain tc) {
        Optional<String> executable = this.getJPackageFromToolchain(tc);
        return executable.isPresent() ? executable : this.getJPackageFromJdkHome(System.getProperty("java.home"));
    }

    private void execute(List<String> parameters) throws Exception {
        Process process = new ProcessBuilder(new String[0]).redirectErrorStream(true).command(parameters).start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.getLog().info((CharSequence)line);
            }
        }
        int status = process.waitFor();
        if (status != 0) {
            throw new MojoExecutionException("Error while executing jpackage");
        }
    }

    private void buildParameters(List<String> parameters) throws MojoFailureException {
        this.getLog().info((CharSequence)"jpackage options:");
        this.addMandatoryParameter(parameters, "--name", this.name);
        this.addMandatoryParameter(parameters, "--dest", this.destination);
        this.addParameter(parameters, "--verbose", this.verbose);
        this.addParameter(parameters, this.type);
        this.addParameter(parameters, "--app-version", this.appVersion);
        this.addParameter(parameters, "--copyright", this.copyright);
        this.addParameter(parameters, "--description", this.description);
        this.addParameter(parameters, "--runtime-image", this.runtimeImage, true);
        this.addParameter(parameters, "--input", this.input, true);
        this.addParameter(parameters, "--install-dir", this.installDir);
        this.addParameter(parameters, "--resource-dir", this.resourceDir, true);
        this.addParameter(parameters, "--vendor", this.vendor);
        this.addParameter(parameters, "--module", this.module);
        this.addParameter(parameters, "--main-class", this.mainClass);
        this.addParameter(parameters, "--main-jar", this.mainJar);
        this.addParameter(parameters, "--temp", this.temp);
        this.addParameter(parameters, "--icon", this.icon, true);
        this.addParameter(parameters, "--license-file", this.licenseFile, true);
        this.addParameter(parameters, "--app-image", this.appImage, true);
        if (this.modulePaths != null) {
            for (File modulePath : this.modulePaths) {
                this.addParameter(parameters, "--module-path", modulePath, true);
            }
        }
        if (this.addModules != null && !this.addModules.isEmpty()) {
            this.addParameter(parameters, "--add-modules", String.join((CharSequence)",", this.addModules));
        }
        if (this.javaOptions != null) {
            for (String option : this.javaOptions) {
                this.addParameter(parameters, "--java-options", StringUtil.escape(option));
            }
        }
        if (this.arguments != null) {
            for (String arg : this.arguments) {
                this.addParameter(parameters, "--arguments", StringUtil.escape(arg));
            }
        }
        if (this.fileAssociations != null) {
            for (File association : this.fileAssociations) {
                this.addParameter(parameters, "--file-associations", association, true);
            }
        }
        if (this.launchers != null) {
            for (Launcher launcher : this.launchers) {
                launcher.validate();
                this.addParameter(parameters, "--add-launcher", launcher.getName() + "=" + launcher.getFile().getAbsolutePath());
            }
        }
        if (this.additionalOptions != null) {
            for (String option : this.additionalOptions) {
                this.addParameter(parameters, option);
            }
        }
        if (OsUtil.isMac()) {
            this.addParameter(parameters, "--mac-package-identifier", this.macPackageIdentifier);
            this.addParameter(parameters, "--mac-package-name", this.macPackageName);
            this.addParameter(parameters, "--mac-package-signing-prefix", this.macPackageSigningPrefix);
            this.addParameter(parameters, "--mac-sign", this.macSign);
            this.addParameter(parameters, "--mac-signing-keychain", this.macSigningKeychain, true);
            this.addParameter(parameters, "--mac-signing-key-user-name", this.macSigningKeyUserName);
        } else if (OsUtil.isWindows()) {
            this.addParameter(parameters, "--win-menu", this.winMenu);
            this.addParameter(parameters, "--win-dir-chooser", this.winDirChooser);
            this.addParameter(parameters, "--win-upgrade-uuid", this.winUpgradeUuid);
            this.addParameter(parameters, "--win-menu-group", this.winMenuGroup);
            this.addParameter(parameters, "--win-shortcut", this.winShortcut);
            this.addParameter(parameters, "--win-per-user-install", this.winPerUserInstall);
            this.addParameter(parameters, "--win-console", this.winConsole);
        } else if (OsUtil.isLinux()) {
            this.addParameter(parameters, "--linux-package-name", this.linuxPackageName);
            this.addParameter(parameters, "--linux-deb-maintainer", this.linuxDebMaintainer);
            this.addParameter(parameters, "--linux-menu-group", this.linuxMenuGroup);
            this.addParameter(parameters, "--linux-rpm-license-type", this.linuxRpmLicenseType);
            this.addParameter(parameters, "--linux-app-release", this.linuxAppRelease);
            this.addParameter(parameters, "--linux-app-category", this.linuxAppCategory);
            this.addParameter(parameters, "--linux-shortcut", this.linuxShortcut);
        }
    }

    private void addMandatoryParameter(List<String> params, String name, String value) throws MojoFailureException {
        if (value == null || value.isEmpty()) {
            throw new MojoFailureException("Mandatory parameter \"" + name + "\" cannot be null or empty");
        }
        this.addParameter(params, name, value);
    }

    private void addMandatoryParameter(List<String> params, String name, File value) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException("Mandatory parameter \"" + name + "\" cannot be null or empty");
        }
        this.addParameter(params, name, value);
    }

    private void addParameter(List<String> params, String name, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name + " " + value));
        params.add(name);
        params.add(value);
    }

    private void addParameter(List<String> params, String name, File value) throws MojoFailureException {
        this.addParameter(params, name, value, false);
    }

    private void addParameter(List<String> params, String name, File value, boolean checkExistence) throws MojoFailureException {
        if (value == null) {
            return;
        }
        if (checkExistence && !value.exists()) {
            throw new MojoFailureException("File or directory " + value.getAbsolutePath() + " does not exist");
        }
        this.addParameter(params, name, value.getAbsolutePath());
    }

    private void addParameter(List<String> params, String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name));
        params.add(name);
    }

    private void addParameter(List<String> params, String name, boolean value) {
        if (!value) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name));
        params.add(name);
    }

    private void addParameter(List<String> params, EnumParameter value) {
        if (value == null) {
            return;
        }
        this.addParameter(params, value.getParameterName(), value.getValue());
    }
}

