/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage;

import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.panteleyev.jpackage.CommandLineParameter;
import org.panteleyev.jpackage.EnumParameter;
import org.panteleyev.jpackage.ImageType;
import org.panteleyev.jpackage.Launcher;
import org.panteleyev.jpackage.OsUtil;
import org.panteleyev.jpackage.StringUtil;

@Mojo(name="jpackage", defaultPhase=LifecyclePhase.NONE)
public class JPackageMojo
extends AbstractMojo {
    public static final String GOAL = "jpackage";
    private static final String TOOLCHAIN = "jdk";
    public static final String EXECUTABLE = "jpackage";
    private static final String DRY_RUN_PROPERTY = "jpackage.dryRun";
    @Component
    private ToolchainManager toolchainManager;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter
    private boolean verbose;
    @Parameter
    private ImageType type;
    @Parameter(defaultValue="${project.name}")
    private String name;
    @Parameter(defaultValue="${project.version}")
    private String appVersion;
    @Parameter
    private String vendor;
    @Parameter
    private File icon;
    @Parameter
    private File runtimeImage;
    @Parameter
    private File input;
    @Parameter
    private String installDir;
    @Parameter
    private File resourceDir;
    @Parameter
    private File destination;
    @Parameter
    private String module;
    @Parameter
    private String mainClass;
    @Parameter
    private String mainJar;
    @Parameter
    private File temp;
    @Parameter
    private String copyright;
    @Parameter
    private String description;
    @Parameter
    private List<File> modulePaths;
    @Parameter
    private List<String> javaOptions;
    @Parameter
    private List<String> arguments;
    @Parameter
    private File licenseFile;
    @Parameter
    private List<File> fileAssociations;
    @Parameter
    private List<Launcher> launchers;
    @Parameter
    private List<String> addModules;
    @Parameter
    private File appImage;
    @Parameter
    private List<String> additionalOptions;
    @Parameter
    private List<String> jLinkOptions;
    @Parameter
    private boolean bindServices;
    @Parameter
    private String aboutUrl;
    @Parameter
    private List<File> appContentPaths;
    @Parameter
    private boolean launcherAsService;
    @Parameter
    private boolean winMenu;
    @Parameter
    private boolean winDirChooser;
    @Parameter
    private String winHelpUrl;
    @Parameter
    private String winUpgradeUuid;
    @Parameter
    private String winMenuGroup;
    @Parameter
    private boolean winShortcut;
    @Parameter
    private boolean winShortcutPrompt;
    @Parameter
    private String winUpdateUrl;
    @Parameter
    private boolean winPerUserInstall;
    @Parameter
    private boolean winConsole;
    @Parameter
    private String macPackageIdentifier;
    @Parameter
    private String macPackageName;
    @Parameter
    private String macBundleSigningPrefix;
    @Parameter
    private String macPackageSigningPrefix;
    @Parameter
    private boolean macSign;
    @Parameter
    private File macSigningKeychain;
    @Parameter
    private String macSigningKeyUserName;
    @Parameter
    private boolean macAppStore;
    @Parameter
    private File macEntitlements;
    @Parameter
    private String macAppCategory;
    @Parameter
    private List<File> macDmgContentPaths;
    @Parameter
    private String linuxPackageName;
    @Parameter
    private String linuxDebMaintainer;
    @Parameter
    private String linuxMenuGroup;
    @Parameter
    private boolean linuxPackageDeps;
    @Parameter
    private String linuxRpmLicenseType;
    @Parameter
    private String linuxAppRelease;
    @Parameter
    private String linuxAppCategory;
    @Parameter
    private boolean linuxShortcut;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String executable;
        int majorVersion;
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext(TOOLCHAIN, this.session);
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in jpackage-maven-plugin: " + tc));
        }
        if ((majorVersion = this.getMajorVersion(executable = this.getJPackageExecutable(tc).orElseThrow(() -> new MojoExecutionException("Failed to find jpackage")))) == 0) {
            throw new MojoExecutionException("Could not determine jpackage version");
        }
        this.getLog().info((CharSequence)("Using: " + executable + ", major version: " + majorVersion));
        Commandline commandLine = this.buildParameters(majorVersion);
        commandLine.setExecutable(executable.contains(" ") ? "\"" + executable + "\"" : executable);
        boolean dryRun = "true".equalsIgnoreCase(System.getProperty(DRY_RUN_PROPERTY, "false"));
        if (dryRun) {
            this.getLog().warn((CharSequence)"Dry-run mode, not executing jpackage");
        } else {
            try {
                this.execute(commandLine);
            }
            catch (Exception ex) {
                throw new MojoExecutionException(ex.getMessage(), ex);
            }
        }
    }

    private Optional<String> getJPackageFromJdkHome(String jdkHome) {
        if (jdkHome == null || jdkHome.isEmpty()) {
            return Optional.empty();
        }
        this.getLog().debug((CharSequence)("Looking for jpackage in " + jdkHome));
        String executable = jdkHome + File.separator + "bin" + File.separator + "jpackage";
        if (OsUtil.isWindows()) {
            executable = executable + ".exe";
        }
        if (new File(executable).exists()) {
            return Optional.of(executable);
        }
        this.getLog().warn((CharSequence)("File " + executable + " does not exist"));
        return Optional.empty();
    }

    private Optional<String> getJPackageFromToolchain(Toolchain tc) {
        if (tc == null) {
            return Optional.empty();
        }
        String executable = tc.findTool("jpackage");
        if (executable == null) {
            this.getLog().warn((CharSequence)"jpackage is not part of configured toolchain");
        }
        return Optional.ofNullable(executable);
    }

    private Optional<String> getJPackageExecutable(Toolchain tc) {
        Optional<String> executable = this.getJPackageFromToolchain(tc);
        return executable.isPresent() ? executable : this.getJPackageFromJdkHome(System.getProperty("java.home"));
    }

    private void execute(Commandline commandline) throws Exception {
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            String output;
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)out, (StreamConsumer)err);
            String string = output = StringUtil.isEmpty(out.getOutput()) ? null : '\n' + out.getOutput().trim();
            if (exitCode != 0) {
                if (StringUtil.isNotEmpty(output)) {
                    for (String line : output.split("\n")) {
                        this.getLog().error((CharSequence)line);
                    }
                }
                StringBuilder msg = new StringBuilder("\nExit code: ").append(exitCode);
                String errOutput = err.getOutput();
                if (StringUtil.isNotEmpty(errOutput)) {
                    msg.append(" - ").append(errOutput);
                }
                msg.append('\n');
                msg.append("Command line was: ").append(commandline).append('\n').append('\n');
                throw new MojoExecutionException(msg.toString());
            }
            if (StringUtil.isNotEmpty(output)) {
                for (String outputLine : output.split("\n")) {
                    this.getLog().info((CharSequence)outputLine);
                }
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing jpackage: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private Commandline buildParameters(int version) throws MojoFailureException {
        this.getLog().info((CharSequence)"jpackage options:");
        Commandline commandline = new Commandline();
        this.addMandatoryParameter(commandline, CommandLineParameter.NAME, this.name, version);
        this.addMandatoryParameter(commandline, CommandLineParameter.DESTINATION, this.destination, false, version);
        this.addParameter(commandline, CommandLineParameter.VERBOSE, this.verbose, version);
        this.addParameter(commandline, CommandLineParameter.TYPE, this.type, version);
        this.addParameter(commandline, CommandLineParameter.APP_VERSION, this.appVersion, version);
        this.addParameter(commandline, CommandLineParameter.COPYRIGHT, this.copyright, version);
        this.addParameter(commandline, CommandLineParameter.DESCRIPTION, this.description, version);
        this.addParameter(commandline, CommandLineParameter.RUNTIME_IMAGE, this.runtimeImage, true, version);
        this.addParameter(commandline, CommandLineParameter.INPUT, this.input, true, version);
        this.addParameter(commandline, CommandLineParameter.INSTALL_DIR, this.installDir, version);
        this.addParameter(commandline, CommandLineParameter.RESOURCE_DIR, this.resourceDir, true, version);
        this.addParameter(commandline, CommandLineParameter.VENDOR, this.vendor, version);
        this.addParameter(commandline, CommandLineParameter.MODULE, this.module, version);
        this.addParameter(commandline, CommandLineParameter.MAIN_CLASS, this.mainClass, version);
        this.addParameter(commandline, CommandLineParameter.MAIN_JAR, this.mainJar, version);
        this.addParameter(commandline, CommandLineParameter.TEMP, this.temp, false, version);
        this.addParameter(commandline, CommandLineParameter.ICON, this.icon, true, version);
        this.addParameter(commandline, CommandLineParameter.LICENSE_FILE, this.licenseFile, true, version);
        this.addParameter(commandline, CommandLineParameter.ABOUT_URL, this.aboutUrl, version);
        this.addParameter(commandline, CommandLineParameter.APP_IMAGE, this.appImage, true, version);
        this.addParameter(commandline, CommandLineParameter.LAUNCHER_AS_SERVICE, this.launcherAsService, version);
        if (this.modulePaths != null) {
            for (File modulePath : this.modulePaths) {
                this.addParameter(commandline, CommandLineParameter.MODULE_PATH, modulePath, true, version);
            }
        }
        if (this.addModules != null && !this.addModules.isEmpty()) {
            this.addParameter(commandline, CommandLineParameter.ADD_MODULES, String.join((CharSequence)",", this.addModules), version);
        }
        this.addParameter(commandline, CommandLineParameter.BIND_SERVICES, this.bindServices, version);
        if (this.jLinkOptions != null && !this.jLinkOptions.isEmpty()) {
            this.addParameter(commandline, CommandLineParameter.JLINK_OPTIONS, String.join((CharSequence)" ", this.jLinkOptions), version);
        }
        if (this.javaOptions != null) {
            for (String option : this.javaOptions) {
                this.addParameter(commandline, CommandLineParameter.JAVA_OPTIONS, StringUtil.escape(option), version);
            }
        }
        if (this.arguments != null) {
            for (String arg : this.arguments) {
                this.addParameter(commandline, CommandLineParameter.ARGUMENTS, StringUtil.escape(arg), version);
            }
        }
        if (this.fileAssociations != null) {
            for (File association : this.fileAssociations) {
                this.addParameter(commandline, CommandLineParameter.FILE_ASSOCIATIONS, association, true, version);
            }
        }
        if (this.appContentPaths != null) {
            for (File appContent : this.appContentPaths) {
                this.addParameter(commandline, CommandLineParameter.APP_CONTENT, appContent, true, version);
            }
        }
        if (this.launchers != null) {
            for (Launcher launcher : this.launchers) {
                launcher.validate();
                this.addParameter(commandline, CommandLineParameter.ADD_LAUNCHER, launcher.getName() + "=" + launcher.getFile().getAbsolutePath(), version);
            }
        }
        if (this.additionalOptions != null) {
            for (String option : this.additionalOptions) {
                this.addParameter(commandline, option);
            }
        }
        if (OsUtil.isMac()) {
            this.addParameter(commandline, CommandLineParameter.MAC_PACKAGE_IDENTIFIER, this.macPackageIdentifier, version);
            this.addParameter(commandline, CommandLineParameter.MAC_PACKAGE_NAME, this.macPackageName, version);
            this.addParameter(commandline, CommandLineParameter.MAC_BUNDLE_SIGNING_PREFIX, this.macBundleSigningPrefix, version);
            this.addParameter(commandline, CommandLineParameter.MAC_PACKAGE_SIGNING_PREFIX, this.macPackageSigningPrefix, version);
            this.addParameter(commandline, CommandLineParameter.MAC_SIGN, this.macSign, version);
            this.addParameter(commandline, CommandLineParameter.MAC_SIGNING_KEYCHAIN, this.macSigningKeychain, true, version);
            this.addParameter(commandline, CommandLineParameter.MAC_SIGNING_KEY_USER_NAME, this.macSigningKeyUserName, version);
            this.addParameter(commandline, CommandLineParameter.MAC_APP_STORE, this.macAppStore, version);
            this.addParameter(commandline, CommandLineParameter.MAC_ENTITLEMENTS, this.macEntitlements, true, version);
            this.addParameter(commandline, CommandLineParameter.MAC_APP_CATEGORY, this.macAppCategory, version);
            if (this.macDmgContentPaths != null) {
                for (File content : this.macDmgContentPaths) {
                    this.addParameter(commandline, CommandLineParameter.MAC_DMG_CONTENT, content, true, version);
                }
            }
        } else if (OsUtil.isWindows()) {
            this.addParameter(commandline, CommandLineParameter.WIN_CONSOLE, this.winConsole, version);
            this.addParameter(commandline, CommandLineParameter.WIN_DIR_CHOOSER, this.winDirChooser, version);
            this.addParameter(commandline, CommandLineParameter.WIN_HELP_URL, this.winHelpUrl, version);
            this.addParameter(commandline, CommandLineParameter.WIN_MENU, this.winMenu, version);
            this.addParameter(commandline, CommandLineParameter.WIN_MENU_GROUP, this.winMenuGroup, version);
            this.addParameter(commandline, CommandLineParameter.WIN_PER_USER_INSTALL, this.winPerUserInstall, version);
            this.addParameter(commandline, CommandLineParameter.WIN_SHORTCUT, this.winShortcut, version);
            this.addParameter(commandline, CommandLineParameter.WIN_SHORTCUT_PROMPT, this.winShortcutPrompt, version);
            this.addParameter(commandline, CommandLineParameter.WIN_UPDATE_URL, this.winUpdateUrl, version);
            this.addParameter(commandline, CommandLineParameter.WIN_UPGRADE_UUID, this.winUpgradeUuid, version);
        } else if (OsUtil.isLinux()) {
            this.addParameter(commandline, CommandLineParameter.LINUX_PACKAGE_NAME, this.linuxPackageName, version);
            this.addParameter(commandline, CommandLineParameter.LINUX_DEB_MAINTAINER, this.linuxDebMaintainer, version);
            this.addParameter(commandline, CommandLineParameter.LINUX_MENU_GROUP, this.linuxMenuGroup, version);
            this.addParameter(commandline, CommandLineParameter.LINUX_PACKAGE_DEPS, this.linuxPackageDeps, version);
            this.addParameter(commandline, CommandLineParameter.LINUX_RPM_LICENSE_TYPE, this.linuxRpmLicenseType, version);
            this.addParameter(commandline, CommandLineParameter.LINUX_APP_RELEASE, this.linuxAppRelease, version);
            this.addParameter(commandline, CommandLineParameter.LINUX_APP_CATEGORY, this.linuxAppCategory, version);
            this.addParameter(commandline, CommandLineParameter.LINUX_SHORTCUT, this.linuxShortcut, version);
        }
        return commandline;
    }

    private void addMandatoryParameter(Commandline commandline, CommandLineParameter parameter, String value, int version) throws MojoFailureException {
        if (value == null || value.isEmpty()) {
            throw new MojoFailureException("Mandatory parameter \"" + parameter.getName() + "\" cannot be null or empty");
        }
        this.addParameter(commandline, parameter, value, version);
    }

    private void addMandatoryParameter(Commandline commandline, CommandLineParameter parameter, File value, boolean checkExistence, int version) throws MojoFailureException {
        if (value == null) {
            throw new MojoFailureException("Mandatory parameter \"" + parameter.getName() + "\" cannot be null or empty");
        }
        this.addParameter(commandline, parameter, value, checkExistence, version);
    }

    private void addParameter(Commandline commandline, String name, String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name + " " + value));
        commandline.createArg().setValue(name);
        commandline.createArg().setValue(value);
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, String value, int version) throws MojoFailureException {
        if (value == null || value.isEmpty()) {
            return;
        }
        parameter.checkVersion(version);
        this.getLog().info((CharSequence)("  " + parameter.getName() + " " + value));
        commandline.createArg().setValue(parameter.getName());
        commandline.createArg().setValue(value);
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, File value, boolean checkExistence, int version) throws MojoFailureException {
        this.addParameter(commandline, parameter, value, checkExistence, true, version);
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, File value, boolean checkExistence, boolean makeAbsolute, int version) throws MojoFailureException {
        String path;
        if (value == null) {
            return;
        }
        parameter.checkVersion(version);
        String string = path = makeAbsolute ? value.getAbsolutePath() : value.getPath();
        if (checkExistence && !value.exists()) {
            throw new MojoFailureException("File or directory " + path + " does not exist");
        }
        this.addParameter(commandline, parameter.getName(), path);
    }

    private void addParameter(Commandline commandline, String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)("  " + name));
        commandline.createArg().setValue(name);
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, boolean value, int version) throws MojoFailureException {
        if (!value) {
            return;
        }
        parameter.checkVersion(version);
        this.getLog().info((CharSequence)("  " + parameter.getName()));
        commandline.createArg().setValue(parameter.getName());
    }

    private void addParameter(Commandline commandline, CommandLineParameter parameter, EnumParameter value, int version) throws MojoFailureException {
        if (value == null) {
            return;
        }
        this.addParameter(commandline, parameter, value.getValue(), version);
    }

    private int getMajorVersion(String executable) {
        Commandline commandLine = new Commandline();
        commandLine.createArg().setValue("--version");
        commandLine.setExecutable(executable.contains(" ") ? "\"" + executable + "\"" : executable);
        CommandLineUtils.StringStreamConsumer err = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        try {
            int exitCode = CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)out, (StreamConsumer)err);
            if (exitCode != 0) {
                return 0;
            }
            return StringUtil.parseVersion(out.getOutput());
        }
        catch (Exception e) {
            return 0;
        }
    }
}

