/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage.util;

import java.util.regex.Matcher;
import org.panteleyev.jpackage.util.OsUtil;

public final class StringUtil {
    private static final String REPLACER = Matcher.quoteReplacement(OsUtil.isWindows() ? "\\\\\\\"" : "\\\"");
    private static final String SPACE_WRAPPER = OsUtil.isWindows() ? "\\\"" : "\"";

    private StringUtil() {
    }

    public static String escape(String arg) {
        if ((arg = arg.replaceAll("\"", REPLACER)).contains(" ")) {
            arg = SPACE_WRAPPER + arg + SPACE_WRAPPER;
        }
        return arg;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && !s.trim().isEmpty();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static int parseVersion(String versionString) {
        int index;
        if (versionString == null) {
            return 0;
        }
        if ((versionString = versionString.trim()).isEmpty()) {
            return 0;
        }
        for (index = 0; index < versionString.length() && Character.isDigit(versionString.charAt(index)); ++index) {
        }
        try {
            return Integer.parseInt(versionString.substring(0, index));
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }
}

