/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

class IoUtil {
    private IoUtil() {
    }

    public static void pipe(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, File file2, byte[] byArray) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                IoUtil.pipe(fileInputStream, fileOutputStream, byArray);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyZipWithoutEmptyDirectories(File file, File file2) throws IOException {
        byte[] byArray = new byte[8192];
        ZipFile zipFile = new ZipFile(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        ZipOutputStream zipOutputStream = new ZipOutputStream(bufferedOutputStream);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            ArrayList<ZipEntry> arrayList = new ArrayList<ZipEntry>();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                arrayList.add(zipEntry);
            }
            Collections.sort(arrayList, new Comparator<ZipEntry>(){

                @Override
                public int compare(ZipEntry zipEntry, ZipEntry zipEntry2) {
                    return zipEntry.getName().compareTo(zipEntry2.getName());
                }
            });
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Object object;
                ZipEntry zipEntry = (ZipEntry)arrayList.get(i);
                String string = zipEntry.getName();
                boolean bl = zipEntry.isDirectory() ? (i == arrayList.size() - 1 ? true : !((String)(object = ((ZipEntry)arrayList.get(i + 1)).getName())).startsWith(string)) : false;
                if (bl) {
                    arrayList.remove(zipEntry);
                    continue;
                }
                object = new ZipEntry(zipEntry);
                zipOutputStream.putNextEntry((ZipEntry)object);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                IoUtil.pipe(inputStream, byteArrayOutputStream, byArray);
                inputStream.close();
                zipOutputStream.write(byteArrayOutputStream.toByteArray());
            }
        }
        finally {
            zipOutputStream.close();
        }
    }
}

