/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.io.IOException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Checks;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.EmptyVisitor;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;

class ClassNodeInitializer
extends EmptyVisitor {
    private ParserClassNode classNode;
    private Class<?> ownerClass;
    private boolean hasBuildParseTree;
    private boolean hasExplicitActionOnlyAnnotation;
    private boolean hasDontLabelAnnotation;
    private boolean hasSkipActionsInPredicates;

    ClassNodeInitializer() {
    }

    public void process(ParserClassNode classNode) throws IOException {
        this.classNode = (ParserClassNode)((Object)Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode"));
        this.ownerClass = classNode.getParentClass();
        while (!Object.class.equals(this.ownerClass)) {
            this.hasExplicitActionOnlyAnnotation = false;
            this.hasDontLabelAnnotation = false;
            this.hasSkipActionsInPredicates = false;
            ClassReader classReader = AsmUtils.createClassReader(this.ownerClass);
            classReader.accept((ClassVisitor)this, 4);
            this.ownerClass = this.ownerClass.getSuperclass();
        }
        for (RuleMethod method : classNode.getRuleMethods().values()) {
            if (method.isSuperMethod()) {
                RuleMethod overridingMethod = classNode.getRuleMethods().get(method.name.substring(1) + method.desc);
                method.moveFlagsTo(overridingMethod);
                continue;
            }
            if (this.hasBuildParseTree) break;
            method.suppressNode();
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.ownerClass == this.classNode.getParentClass()) {
            Checks.ensure(((access & 2) == 0 ? 1 : 0) != 0, (String)"Parser class '%s' must not be private", (Object[])new Object[]{name});
            Checks.ensure(((access & 0x10) == 0 ? 1 : 0) != 0, (String)"Parser class '%s' must not be final.", (Object[])new Object[]{name});
            this.classNode.visit(49, 1, AsmUtils.getExtendedParserClassName(name), null, this.classNode.getParentType().getInternalName(), null);
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (Types.EXPLICIT_ACTIONS_ONLY_DESC.equals(desc)) {
            this.hasExplicitActionOnlyAnnotation = true;
            return null;
        }
        if (Types.DONT_LABEL_DESC.equals(desc)) {
            this.hasDontLabelAnnotation = true;
            return null;
        }
        if (Types.SKIP_ACTIONS_IN_PREDICATES_DESC.equals(desc)) {
            this.hasSkipActionsInPredicates = true;
            return null;
        }
        if (Types.BUILD_PARSE_TREE_DESC.equals(desc)) {
            this.hasBuildParseTree = true;
            return null;
        }
        return visible && this.ownerClass == this.classNode.getParentClass() ? this.classNode.visitAnnotation(desc, true) : null;
    }

    public void visitSource(String source, String debug) {
        this.classNode.visitSource(null, null);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ("<init>".equals(name)) {
            if (this.ownerClass != this.classNode.getParentClass() || (access & 2) > 0) {
                return null;
            }
            MethodNode constructor = new MethodNode(access, name, desc, signature, exceptions);
            this.classNode.getConstructors().add(constructor);
            return constructor;
        }
        if (!Type.getReturnType((String)desc).equals((Object)Types.RULE) || (access & 0x500) > 0) {
            return null;
        }
        Checks.ensure(((access & 2) == 0 ? 1 : 0) != 0, (String)"Rule method '%s'must not be private.\nMark the method protected or package-private if you want to prevent public access!", (Object[])new Object[]{name});
        Checks.ensure(((access & 0x10) == 0 ? 1 : 0) != 0, (String)"Rule method '%s' must not be final.", (Object[])new Object[]{name});
        String methodKey = name.concat(desc);
        while (this.classNode.getRuleMethods().containsKey(methodKey)) {
            name = '$' + name;
            methodKey = name.concat(desc);
        }
        RuleMethod method = new RuleMethod(this.ownerClass, access, name, desc, signature, exceptions, this.hasExplicitActionOnlyAnnotation, this.hasDontLabelAnnotation, this.hasSkipActionsInPredicates);
        this.classNode.getRuleMethods().put(methodKey, method);
        return method;
    }

    public void visitEnd() {
        this.classNode.visitEnd();
    }
}

