/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

abstract class GroupClassGenerator
implements RuleMethodProcessor {
    private static final Object lock = new Object();
    private final boolean forceCodeBuilding;
    protected ParserClassNode classNode;
    protected RuleMethod method;

    protected GroupClassGenerator(boolean bl) {
        this.forceCodeBuilding = bl;
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        this.classNode = (ParserClassNode)((Object)Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode"));
        this.method = (RuleMethod)((Object)Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method"));
        for (InstructionGroup instructionGroup : ruleMethod.getGroups()) {
            if (!this.appliesTo(instructionGroup.getRoot())) continue;
            this.loadGroupClass(instructionGroup);
        }
    }

    protected abstract boolean appliesTo(InstructionGraphNode var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroupClass(InstructionGroup instructionGroup) {
        this.createGroupClassType(instructionGroup);
        String string = instructionGroup.getGroupClassType().getClassName();
        Object object = lock;
        synchronized (object) {
            Class<?> clazz = AsmUtils.loadClass(string, this.classNode.getParentClass());
            if (clazz == null || this.forceCodeBuilding) {
                byte[] byArray = this.generateGroupClassCode(instructionGroup);
                instructionGroup.setGroupClassCode(byArray);
                if (clazz == null) {
                    AsmUtils.defineClass(string, byArray, this.classNode.getParentClass());
                }
            }
        }
    }

    private void createGroupClassType(InstructionGroup instructionGroup) {
        String string = this.classNode.name;
        int n = this.classNode.name.lastIndexOf(47);
        String string2 = (String)(n >= 0 ? string.substring(0, n) + "/" : "") + instructionGroup.getName();
        instructionGroup.setGroupClassType(Type.getObjectType((String)string2));
    }

    protected byte[] generateGroupClassCode(InstructionGroup instructionGroup) {
        ClassWriter classWriter = new ClassWriter(2);
        this.generateClassBasics(instructionGroup, classWriter);
        this.generateFields(instructionGroup, classWriter);
        this.generateConstructor(classWriter);
        this.generateMethod(instructionGroup, classWriter);
        classWriter.visitEnd();
        return classWriter.toByteArray();
    }

    private void generateClassBasics(InstructionGroup instructionGroup, ClassWriter classWriter) {
        classWriter.visit(51, 4113, instructionGroup.getGroupClassType().getInternalName(), null, this.getBaseType().getInternalName(), null);
        classWriter.visitSource(this.classNode.sourceFile, null);
    }

    protected abstract Type getBaseType();

    private void generateFields(InstructionGroup instructionGroup, ClassWriter classWriter) {
        for (FieldNode fieldNode : instructionGroup.getFields()) {
            classWriter.visitField(4097, fieldNode.name, fieldNode.desc, null, null);
        }
    }

    private void generateConstructor(ClassWriter classWriter) {
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(Ljava/lang/String;)V", null, null);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(183, this.getBaseType().getInternalName(), "<init>", "(Ljava/lang/String;)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    protected abstract void generateMethod(InstructionGroup var1, ClassWriter var2);

    protected void insertSetContextCalls(InstructionGroup instructionGroup, int n) {
        InsnList insnList = instructionGroup.getInstructions();
        for (InstructionGraphNode instructionGraphNode : instructionGroup.getNodes()) {
            if (!instructionGraphNode.isCallOnContextAware()) continue;
            AbstractInsnNode abstractInsnNode = instructionGraphNode.getInstruction();
            if (instructionGraphNode.getPredecessors().size() > 1) {
                AbstractInsnNode abstractInsnNode2 = instructionGraphNode.getPredecessors().get(0).getInstruction();
                insnList.insert(abstractInsnNode2, (AbstractInsnNode)new VarInsnNode(58, ++n));
                insnList.insert(abstractInsnNode2, (AbstractInsnNode)new InsnNode(89));
                insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, n));
            } else {
                insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(89));
            }
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, 1));
            insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(185, Types.CONTEXT_AWARE.getInternalName(), "setContext", "(" + Types.CONTEXT_DESC + ")V", true));
        }
    }

    protected void convertXLoads(InstructionGroup instructionGroup) {
        String string = instructionGroup.getGroupClassType().getInternalName();
        for (InstructionGraphNode instructionGraphNode : instructionGroup.getNodes()) {
            if (!instructionGraphNode.isXLoad()) continue;
            VarInsnNode varInsnNode = (VarInsnNode)instructionGraphNode.getInstruction();
            FieldNode fieldNode = instructionGroup.getFields().get(varInsnNode.var);
            instructionGroup.getInstructions().insert((AbstractInsnNode)varInsnNode, (AbstractInsnNode)new FieldInsnNode(180, string, fieldNode.name, fieldNode.desc));
            instructionGroup.getInstructions().set((AbstractInsnNode)varInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
        }
    }
}

