/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.IntervalQualifier;
import org.partiql.ast.ddl.AttributeConstraint;

public final class DataType
extends AstEnum {
    public static final int CHARACTER = 0;
    public static final int CHAR = 1;
    public static final int CHARACTER_VARYING = 2;
    public static final int CHAR_VARYING = 3;
    public static final int VARCHAR = 4;
    public static final int CHARACTER_LARGE_OBJECT = 5;
    public static final int CHAR_LARGE_OBJECT = 6;
    public static final int CLOB = 7;
    public static final int STRING = 8;
    public static final int SYMBOL = 9;
    public static final int BLOB = 10;
    public static final int BINARY_LARGE_OBJECT = 11;
    public static final int BIT = 12;
    public static final int BIT_VARYING = 13;
    public static final int NUMERIC = 14;
    public static final int DECIMAL = 15;
    public static final int DEC = 16;
    public static final int BIGINT = 17;
    public static final int INT8 = 18;
    public static final int INTEGER8 = 19;
    public static final int INT4 = 20;
    public static final int INTEGER4 = 21;
    public static final int INTEGER = 22;
    public static final int INT = 23;
    public static final int INT2 = 24;
    public static final int INTEGER2 = 25;
    public static final int SMALLINT = 26;
    public static final int TINYINT = 27;
    public static final int FLOAT = 28;
    public static final int REAL = 29;
    public static final int DOUBLE_PRECISION = 30;
    public static final int BOOLEAN = 31;
    public static final int BOOL = 32;
    public static final int DATE = 33;
    public static final int TIME = 34;
    public static final int TIME_WITH_TIME_ZONE = 35;
    public static final int TIMESTAMP = 36;
    public static final int TIMESTAMP_WITH_TIME_ZONE = 37;
    public static final int INTERVAL = 38;
    public static final int STRUCT = 39;
    public static final int TUPLE = 40;
    public static final int LIST = 41;
    public static final int ARRAY = 42;
    public static final int BAG = 43;
    public static final int SEXP = 44;
    public static final int USER_DEFINED = 45;
    private final int code;
    private final Integer precision;
    private final Integer scale;
    private final Integer length;
    private final DataType elementType;
    private final List<StructField> fields;
    private final Identifier name;
    private final IntervalQualifier intervalQualifier;
    @NotNull
    private static final int[] codes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45};

    public static DataType BOOL() {
        return new DataType(32);
    }

    public static DataType BOOLEAN() {
        return new DataType(31);
    }

    public static DataType TINYINT() {
        return new DataType(27);
    }

    public static DataType SMALLINT() {
        return new DataType(26);
    }

    public static DataType INTEGER2() {
        return new DataType(25);
    }

    public static DataType INT2() {
        return new DataType(24);
    }

    public static DataType INTEGER() {
        return new DataType(22);
    }

    public static DataType INT() {
        return new DataType(23);
    }

    public static DataType INTEGER4() {
        return new DataType(21);
    }

    public static DataType INT4() {
        return new DataType(20);
    }

    public static DataType INTEGER8() {
        return new DataType(19);
    }

    public static DataType INT8() {
        return new DataType(18);
    }

    public static DataType BIGINT() {
        return new DataType(17);
    }

    public static DataType REAL() {
        return new DataType(29);
    }

    public static DataType DOUBLE_PRECISION() {
        return new DataType(30);
    }

    public static DataType FLOAT() {
        return new DataType(28);
    }

    public static DataType FLOAT(int precision) {
        return new DataType(28, precision, null, null);
    }

    public static DataType DECIMAL() {
        return new DataType(15);
    }

    public static DataType DECIMAL(int precision) {
        return new DataType(15, precision, null, null);
    }

    public static DataType DECIMAL(int precision, int scale) {
        return new DataType(15, precision, scale, null);
    }

    public static DataType DEC() {
        return new DataType(16);
    }

    public static DataType DEC(int precision) {
        return new DataType(16, precision, null, null);
    }

    public static DataType DEC(int precision, int scale) {
        return new DataType(16, precision, scale, null);
    }

    public static DataType NUMERIC() {
        return new DataType(14);
    }

    public static DataType NUMERIC(int precision) {
        return new DataType(14, precision, null, null);
    }

    public static DataType NUMERIC(int precision, int scale) {
        return new DataType(14, precision, scale, null);
    }

    public static DataType BIT() {
        return new DataType(12);
    }

    public static DataType BIT(int length) {
        return new DataType(12, null, null, length);
    }

    public static DataType BIT_VARYING() {
        return new DataType(13);
    }

    public static DataType BIT_VARYING(int length) {
        return new DataType(13, null, null, length);
    }

    public static DataType CHAR() {
        return new DataType(1);
    }

    public static DataType CHAR(int length) {
        return new DataType(1, null, null, length);
    }

    public static DataType CHARACTER() {
        return new DataType(0);
    }

    public static DataType CHARACTER(int length) {
        return new DataType(0, null, null, length);
    }

    public static DataType VARCHAR() {
        return new DataType(4);
    }

    public static DataType VARCHAR(int length) {
        return new DataType(4, null, null, length);
    }

    public static DataType CHARACTER_LARGE_OBJECT() {
        return new DataType(5);
    }

    public static DataType CHARACTER_LARGE_OBJECT(int length) {
        return new DataType(5, null, null, length);
    }

    public static DataType CHAR_LARGE_OBJECT() {
        return new DataType(6);
    }

    public static DataType CHAR_LARGE_OBJECT(int length) {
        return new DataType(6, null, null, length);
    }

    public static DataType CHARACTER_VARYING() {
        return new DataType(2);
    }

    public static DataType CHAR_VARYING() {
        return new DataType(3);
    }

    public static DataType CHAR_VARYING(int length) {
        return new DataType(3, null, null, length);
    }

    public static DataType CHARACTER_VARYING(int length) {
        return new DataType(2, null, null, length);
    }

    public static DataType STRING() {
        return new DataType(8);
    }

    public static DataType STRING(int length) {
        return new DataType(8, null, null, length);
    }

    public static DataType SYMBOL() {
        return new DataType(9);
    }

    public static DataType BLOB() {
        return new DataType(10);
    }

    public static DataType BLOB(int length) {
        return new DataType(10, null, null, length);
    }

    public static DataType BINARY_LARGE_OBJECT() {
        return new DataType(11);
    }

    public static DataType BINARY_LARGE_OBJECT(int length) {
        return new DataType(11, null, null, length);
    }

    public static DataType CLOB() {
        return new DataType(7);
    }

    public static DataType CLOB(int length) {
        return new DataType(7, null, null, length);
    }

    public static DataType DATE() {
        return new DataType(33);
    }

    public static DataType STRUCT() {
        return new DataType(39);
    }

    public static DataType TUPLE() {
        return new DataType(40);
    }

    public static DataType LIST() {
        return new DataType(41);
    }

    public static DataType ARRAY() {
        return new DataType(42);
    }

    public static DataType SEXP() {
        return new DataType(44);
    }

    public static DataType BAG() {
        return new DataType(43);
    }

    public static DataType TIME() {
        return new DataType(34);
    }

    public static DataType TIME(int precision) {
        return new DataType(34, precision, null, null);
    }

    public static DataType TIMESTAMP() {
        return new DataType(36);
    }

    public static DataType TIMESTAMP(int precision) {
        return new DataType(36, precision, null, null);
    }

    public static DataType TIME_WITH_TIME_ZONE() {
        return new DataType(35);
    }

    public static DataType TIME_WITH_TIME_ZONE(int precision) {
        return new DataType(35, precision, null, null);
    }

    public static DataType TIMESTAMP_WITH_TIME_ZONE() {
        return new DataType(37);
    }

    public static DataType TIMESTAMP_WITH_TIME_ZONE(int precision) {
        return new DataType(37, precision, null, null);
    }

    @Deprecated
    public static DataType INTERVAL() {
        return new DataType(38);
    }

    public static DataType INTERVAL(@NotNull IntervalQualifier qualifier) {
        return new DataType(qualifier);
    }

    public static DataType USER_DEFINED() {
        return new DataType(45);
    }

    public static DataType USER_DEFINED(@NotNull Identifier name) {
        return new DataType(45, name);
    }

    public static DataType ARRAY(DataType elementType) {
        return new DataType(42, elementType);
    }

    public static DataType STRUCT(List<StructField> fields) {
        return new DataType(39, fields);
    }

    private DataType(int code) {
        this.code = code;
        this.precision = null;
        this.scale = null;
        this.length = null;
        this.elementType = null;
        this.fields = null;
        this.name = null;
        this.intervalQualifier = null;
    }

    private DataType(IntervalQualifier intervalQualifier) {
        this(38, null, null, null, null, null, null, intervalQualifier);
    }

    private DataType(int code, Integer precision, Integer scale, Integer length, DataType elementType, List<StructField> fields, Identifier name, IntervalQualifier intervalQualifier) {
        this.code = code;
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.elementType = elementType;
        this.fields = fields;
        this.name = name;
        this.intervalQualifier = intervalQualifier;
    }

    private DataType(int code, Integer precision, Integer scale, Integer length) {
        this.code = code;
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.elementType = null;
        this.fields = null;
        this.name = null;
        this.intervalQualifier = null;
    }

    private DataType(int code, DataType elementType) {
        this.code = code;
        this.precision = null;
        this.scale = null;
        this.length = null;
        this.elementType = elementType;
        this.fields = null;
        this.name = null;
        this.intervalQualifier = null;
    }

    private DataType(int code, List<StructField> fields) {
        this.code = code;
        this.precision = null;
        this.scale = null;
        this.length = null;
        this.elementType = null;
        this.fields = fields;
        this.name = null;
        this.intervalQualifier = null;
    }

    private DataType(int code, Identifier name) {
        this.code = code;
        this.name = name;
        this.precision = null;
        this.scale = null;
        this.length = null;
        this.elementType = null;
        this.fields = null;
        this.intervalQualifier = null;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "CHARACTER";
            }
            case 1: {
                return "CHAR";
            }
            case 2: {
                return "CHARACTER_VARYING";
            }
            case 3: {
                return "CHAR_VARYING";
            }
            case 4: {
                return "VARCHAR";
            }
            case 5: {
                return "CHARACTER_LARGE_OBJECT";
            }
            case 6: {
                return "CHAR_LARGE_OBJECT";
            }
            case 7: {
                return "CLOB";
            }
            case 8: {
                return "STRING";
            }
            case 9: {
                return "SYMBOL";
            }
            case 10: {
                return "BLOB";
            }
            case 11: {
                return "BINARY_LARGE_OBJECT";
            }
            case 12: {
                return "BIT";
            }
            case 13: {
                return "BIT_VARYING";
            }
            case 14: {
                return "NUMERIC";
            }
            case 15: {
                return "DECIMAL";
            }
            case 16: {
                return "DEC";
            }
            case 17: {
                return "BIGINT";
            }
            case 18: {
                return "INT8";
            }
            case 19: {
                return "INTEGER8";
            }
            case 20: {
                return "INT4";
            }
            case 21: {
                return "INTEGER4";
            }
            case 22: {
                return "INTEGER";
            }
            case 23: {
                return "INT";
            }
            case 24: {
                return "INT2";
            }
            case 25: {
                return "INTEGER2";
            }
            case 26: {
                return "SMALLINT";
            }
            case 27: {
                return "TINYINT";
            }
            case 28: {
                return "FLOAT";
            }
            case 29: {
                return "REAL";
            }
            case 30: {
                return "DOUBLE_PRECISION";
            }
            case 31: {
                return "BOOLEAN";
            }
            case 32: {
                return "BOOL";
            }
            case 33: {
                return "DATE";
            }
            case 34: {
                return "TIME";
            }
            case 35: {
                return "TIME_WITH_TIME_ZONE";
            }
            case 36: {
                return "TIMESTAMP";
            }
            case 37: {
                return "TIMESTAMP_WITH_TIME_ZONE";
            }
            case 38: {
                return "INTERVAL";
            }
            case 39: {
                return "STRUCT";
            }
            case 40: {
                return "TUPLE";
            }
            case 41: {
                return "LIST";
            }
            case 42: {
                return "ARRAY";
            }
            case 43: {
                return "BAG";
            }
            case 44: {
                return "SEXP";
            }
            case 45: {
                return "USER_DEFINED";
            }
        }
        throw new IllegalStateException("Invalid DataType code: " + this.code);
    }

    @NotNull
    public static DataType parse(@NotNull String value) {
        switch (value) {
            case "BOOL": {
                return DataType.BOOL();
            }
            case "BOOLEAN": {
                return DataType.BOOLEAN();
            }
            case "TINYINT": {
                return DataType.TINYINT();
            }
            case "SMALLINT": {
                return DataType.SMALLINT();
            }
            case "INTEGER2": {
                return DataType.INTEGER2();
            }
            case "INT2": {
                return DataType.INT2();
            }
            case "INTEGER": {
                return DataType.INTEGER();
            }
            case "INT": {
                return DataType.INT();
            }
            case "INTEGER4": {
                return DataType.INTEGER4();
            }
            case "INT4": {
                return DataType.INT4();
            }
            case "INTEGER8": {
                return DataType.INTEGER8();
            }
            case "INT8": {
                return DataType.INT8();
            }
            case "BIGINT": {
                return DataType.BIGINT();
            }
            case "REAL": {
                return DataType.REAL();
            }
            case "DOUBLE_PRECISION": {
                return DataType.DOUBLE_PRECISION();
            }
            case "FLOAT": {
                return DataType.FLOAT();
            }
            case "DECIMAL": {
                return DataType.DECIMAL();
            }
            case "DEC": {
                return DataType.DEC();
            }
            case "NUMERIC": {
                return DataType.NUMERIC();
            }
            case "BIT": {
                return DataType.BIT();
            }
            case "BIT_VARYING": {
                return DataType.BIT_VARYING();
            }
            case "CHAR": {
                return DataType.CHAR();
            }
            case "CHARACTER": {
                return DataType.CHARACTER();
            }
            case "VARCHAR": {
                return DataType.VARCHAR();
            }
            case "CHARACTER_LARGE_OBJECT": {
                return DataType.CHARACTER_LARGE_OBJECT();
            }
            case "CHAR_LARGE_OBJECT": {
                return DataType.CHAR_LARGE_OBJECT();
            }
            case "CHAR_VARYING": {
                return DataType.CHAR_VARYING();
            }
            case "STRING": {
                return DataType.STRING();
            }
            case "SYMBOL": {
                return DataType.SYMBOL();
            }
            case "BLOB": {
                return DataType.BLOB();
            }
            case "BINARY_LARGE_OBJECT": {
                return DataType.BINARY_LARGE_OBJECT();
            }
            case "CLOB": {
                return DataType.CLOB();
            }
            case "DATE": {
                return DataType.DATE();
            }
            case "STRUCT": {
                return DataType.STRUCT();
            }
            case "TUPLE": {
                return DataType.TUPLE();
            }
            case "LIST": {
                return DataType.LIST();
            }
            case "ARRAY": {
                return DataType.ARRAY();
            }
            case "SEXP": {
                return DataType.SEXP();
            }
            case "BAG": {
                return DataType.BAG();
            }
            case "TIME": {
                return DataType.TIME();
            }
            case "TIME_WITH_TIME_ZONE": {
                return DataType.TIME_WITH_TIME_ZONE();
            }
            case "TIMESTAMP": {
                return DataType.TIMESTAMP();
            }
            case "TIMESTAMP_WITH_TIME_ZONE": {
                return DataType.TIMESTAMP_WITH_TIME_ZONE();
            }
            case "INTERVAL": {
                return DataType.INTERVAL();
            }
            case "USER_DEFINED": {
                return DataType.USER_DEFINED();
            }
        }
        throw new IllegalArgumentException("No enum constant DataType." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getLength() {
        return this.length;
    }

    public Identifier getName() {
        return this.name;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public List<StructField> getFields() {
        return this.fields;
    }

    @Nullable
    public IntervalQualifier getIntervalQualifier() {
        return this.intervalQualifier;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        if (this.name != null) {
            kids.add(this.name);
        }
        if (this.elementType != null) {
            kids.add(this.elementType);
        }
        if (this.fields != null) {
            kids.addAll(this.fields);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitDataType(this, ctx);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType other = (DataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.code != other.code) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        DataType this$elementType = this.getElementType();
        DataType other$elementType = other.getElementType();
        if (this$elementType == null ? other$elementType != null : !((Object)this$elementType).equals(other$elementType)) {
            return false;
        }
        List<StructField> this$fields = this.getFields();
        List<StructField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Identifier this$name = this.getName();
        Identifier other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        IntervalQualifier this$intervalQualifier = this.getIntervalQualifier();
        IntervalQualifier other$intervalQualifier = other.getIntervalQualifier();
        return !(this$intervalQualifier == null ? other$intervalQualifier != null : !((Object)this$intervalQualifier).equals(other$intervalQualifier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        DataType $elementType = this.getElementType();
        result = result * 59 + ($elementType == null ? 43 : ((Object)$elementType).hashCode());
        List<StructField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Identifier $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        IntervalQualifier $intervalQualifier = this.getIntervalQualifier();
        result = result * 59 + ($intervalQualifier == null ? 43 : ((Object)$intervalQualifier).hashCode());
        return result;
    }

    public static class StructField
    extends AstNode {
        @NotNull
        private final Identifier.Simple name;
        @NotNull
        private final DataType type;
        private final boolean optional;
        @NotNull
        private final List<AttributeConstraint> constraints;
        @Nullable
        private final String comment;

        public StructField(@NotNull Identifier.Simple name, @NotNull DataType type, boolean optional, @NotNull List<AttributeConstraint> constraints, @Nullable String comment) {
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.constraints = constraints;
            this.comment = comment;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.add(this.name);
            kids.add(this.type);
            kids.addAll(this.constraints);
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitDataTypeStructField(this, ctx);
        }

        @NotNull
        public Identifier.Simple getName() {
            return this.name;
        }

        @NotNull
        public DataType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @NotNull
        public List<AttributeConstraint> getConstraints() {
            return this.constraints;
        }

        @Nullable
        public String getComment() {
            return this.comment;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StructField)) {
                return false;
            }
            StructField other = (StructField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            Identifier.Simple this$name = this.getName();
            Identifier.Simple other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            DataType this$type = this.getType();
            DataType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            List<AttributeConstraint> this$constraints = this.getConstraints();
            List<AttributeConstraint> other$constraints = other.getConstraints();
            if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof StructField;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            Identifier.Simple $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            DataType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            List<AttributeConstraint> $constraints = this.getConstraints();
            result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            return result;
        }
    }
}

