/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class DatetimeField
extends AstEnum {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int TIMEZONE_HOUR = 6;
    public static final int TIMEZONE_MINUTE = 7;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public static DatetimeField YEAR() {
        return new DatetimeField(0);
    }

    public static DatetimeField MONTH() {
        return new DatetimeField(1);
    }

    public static DatetimeField DAY() {
        return new DatetimeField(2);
    }

    public static DatetimeField HOUR() {
        return new DatetimeField(3);
    }

    public static DatetimeField MINUTE() {
        return new DatetimeField(4);
    }

    public static DatetimeField SECOND() {
        return new DatetimeField(5);
    }

    public static DatetimeField TIMEZONE_HOUR() {
        return new DatetimeField(6);
    }

    public static DatetimeField TIMEZONE_MINUTE() {
        return new DatetimeField(7);
    }

    private DatetimeField(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "YEAR";
            }
            case 1: {
                return "MONTH";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "HOUR";
            }
            case 4: {
                return "MINUTE";
            }
            case 5: {
                return "SECOND";
            }
            case 6: {
                return "TIMEZONE_HOUR";
            }
            case 7: {
                return "TIMEZONE_MINUTE";
            }
        }
        throw new IllegalStateException("Invalid DatetimeField code: " + this.code);
    }

    @NotNull
    public static DatetimeField parse(@NotNull String value) {
        switch (value) {
            case "YEAR": {
                return DatetimeField.YEAR();
            }
            case "MONTH": {
                return DatetimeField.MONTH();
            }
            case "DAY": {
                return DatetimeField.DAY();
            }
            case "HOUR": {
                return DatetimeField.HOUR();
            }
            case "MINUTE": {
                return DatetimeField.MINUTE();
            }
            case "SECOND": {
                return DatetimeField.SECOND();
            }
            case "TIMEZONE_HOUR": {
                return DatetimeField.TIMEZONE_HOUR();
            }
            case "TIMEZONE_MINUTE": {
                return DatetimeField.TIMEZONE_MINUTE();
            }
        }
        throw new IllegalArgumentException("No enum constant DatetimeField." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatetimeField)) {
            return false;
        }
        DatetimeField other = (DatetimeField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DatetimeField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

