/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.FromTableRef;
import org.partiql.ast.FromType;
import org.partiql.ast.Identifier;
import org.partiql.ast.expr.Expr;

public final class FromExpr
extends FromTableRef {
    @NotNull
    private final Expr expr;
    @NotNull
    private final FromType fromType;
    @Nullable
    private final Identifier.Simple asAlias;
    @Nullable
    private final Identifier.Simple atAlias;

    public FromExpr(@NotNull Expr expr, @NotNull FromType fromType, @Nullable Identifier.Simple asAlias, @Nullable Identifier.Simple atAlias) {
        this.expr = expr;
        this.fromType = fromType;
        this.asAlias = asAlias;
        this.atAlias = atAlias;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.expr);
        if (this.asAlias != null) {
            kids.add(this.asAlias);
        }
        if (this.atAlias != null) {
            kids.add(this.atAlias);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitFromExpr(this, ctx);
    }

    @NotNull
    public Expr getExpr() {
        return this.expr;
    }

    @NotNull
    public FromType getFromType() {
        return this.fromType;
    }

    @Nullable
    public Identifier.Simple getAsAlias() {
        return this.asAlias;
    }

    @Nullable
    public Identifier.Simple getAtAlias() {
        return this.atAlias;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FromExpr)) {
            return false;
        }
        FromExpr other = (FromExpr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expr this$expr = this.getExpr();
        Expr other$expr = other.getExpr();
        if (this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr)) {
            return false;
        }
        FromType this$fromType = this.getFromType();
        FromType other$fromType = other.getFromType();
        if (this$fromType == null ? other$fromType != null : !((Object)this$fromType).equals(other$fromType)) {
            return false;
        }
        Identifier.Simple this$asAlias = this.getAsAlias();
        Identifier.Simple other$asAlias = other.getAsAlias();
        if (this$asAlias == null ? other$asAlias != null : !((Object)this$asAlias).equals(other$asAlias)) {
            return false;
        }
        Identifier.Simple this$atAlias = this.getAtAlias();
        Identifier.Simple other$atAlias = other.getAtAlias();
        return !(this$atAlias == null ? other$atAlias != null : !((Object)this$atAlias).equals(other$atAlias));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FromExpr;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expr $expr = this.getExpr();
        result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
        FromType $fromType = this.getFromType();
        result = result * 59 + ($fromType == null ? 43 : ((Object)$fromType).hashCode());
        Identifier.Simple $asAlias = this.getAsAlias();
        result = result * 59 + ($asAlias == null ? 43 : ((Object)$asAlias).hashCode());
        Identifier.Simple $atAlias = this.getAtAlias();
        result = result * 59 + ($atAlias == null ? 43 : ((Object)$atAlias).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Expr expr;
        @Generated
        private FromType fromType;
        @Generated
        private Identifier.Simple asAlias;
        @Generated
        private Identifier.Simple atAlias;

        @Generated
        Builder() {
        }

        @Generated
        public Builder expr(@NotNull Expr expr) {
            if (expr == null) {
                throw new NullPointerException("expr is marked non-null but is null");
            }
            this.expr = expr;
            return this;
        }

        @Generated
        public Builder fromType(@NotNull FromType fromType) {
            if (fromType == null) {
                throw new NullPointerException("fromType is marked non-null but is null");
            }
            this.fromType = fromType;
            return this;
        }

        @Generated
        public Builder asAlias(@Nullable Identifier.Simple asAlias) {
            this.asAlias = asAlias;
            return this;
        }

        @Generated
        public Builder atAlias(@Nullable Identifier.Simple atAlias) {
            this.atAlias = atAlias;
            return this;
        }

        @Generated
        public FromExpr build() {
            return new FromExpr(this.expr, this.fromType, this.asAlias, this.atAlias);
        }

        @Generated
        public String toString() {
            return "FromExpr.Builder(expr=" + this.expr + ", fromType=" + this.fromType + ", asAlias=" + this.asAlias + ", atAlias=" + this.atAlias + ")";
        }
    }
}

