/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.FromTableRef;
import org.partiql.ast.JoinType;
import org.partiql.ast.expr.Expr;

public final class FromJoin
extends FromTableRef {
    @NotNull
    private final FromTableRef lhs;
    @NotNull
    private final FromTableRef rhs;
    @Nullable
    private final JoinType joinType;
    @Nullable
    private final Expr condition;

    public FromJoin(@NotNull FromTableRef lhs, @NotNull FromTableRef rhs, @Nullable JoinType joinType, @Nullable Expr condition) {
        this.lhs = lhs;
        this.rhs = rhs;
        this.joinType = joinType;
        this.condition = condition;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.lhs);
        kids.add(this.rhs);
        if (this.joinType != null) {
            kids.add(this.joinType);
        }
        if (this.condition != null) {
            kids.add(this.condition);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitFromJoin(this, ctx);
    }

    @NotNull
    public FromTableRef getLhs() {
        return this.lhs;
    }

    @NotNull
    public FromTableRef getRhs() {
        return this.rhs;
    }

    @Nullable
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Nullable
    public Expr getCondition() {
        return this.condition;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FromJoin)) {
            return false;
        }
        FromJoin other = (FromJoin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FromTableRef this$lhs = this.getLhs();
        FromTableRef other$lhs = other.getLhs();
        if (this$lhs == null ? other$lhs != null : !((Object)this$lhs).equals(other$lhs)) {
            return false;
        }
        FromTableRef this$rhs = this.getRhs();
        FromTableRef other$rhs = other.getRhs();
        if (this$rhs == null ? other$rhs != null : !((Object)this$rhs).equals(other$rhs)) {
            return false;
        }
        JoinType this$joinType = this.getJoinType();
        JoinType other$joinType = other.getJoinType();
        if (this$joinType == null ? other$joinType != null : !((Object)this$joinType).equals(other$joinType)) {
            return false;
        }
        Expr this$condition = this.getCondition();
        Expr other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FromJoin;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FromTableRef $lhs = this.getLhs();
        result = result * 59 + ($lhs == null ? 43 : ((Object)$lhs).hashCode());
        FromTableRef $rhs = this.getRhs();
        result = result * 59 + ($rhs == null ? 43 : ((Object)$rhs).hashCode());
        JoinType $joinType = this.getJoinType();
        result = result * 59 + ($joinType == null ? 43 : ((Object)$joinType).hashCode());
        Expr $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private FromTableRef lhs;
        @Generated
        private FromTableRef rhs;
        @Generated
        private JoinType joinType;
        @Generated
        private Expr condition;

        @Generated
        Builder() {
        }

        @Generated
        public Builder lhs(@NotNull FromTableRef lhs) {
            if (lhs == null) {
                throw new NullPointerException("lhs is marked non-null but is null");
            }
            this.lhs = lhs;
            return this;
        }

        @Generated
        public Builder rhs(@NotNull FromTableRef rhs) {
            if (rhs == null) {
                throw new NullPointerException("rhs is marked non-null but is null");
            }
            this.rhs = rhs;
            return this;
        }

        @Generated
        public Builder joinType(@Nullable JoinType joinType) {
            this.joinType = joinType;
            return this;
        }

        @Generated
        public Builder condition(@Nullable Expr condition) {
            this.condition = condition;
            return this;
        }

        @Generated
        public FromJoin build() {
            return new FromJoin(this.lhs, this.rhs, this.joinType, this.condition);
        }

        @Generated
        public String toString() {
            return "FromJoin.Builder(lhs=" + this.lhs + ", rhs=" + this.rhs + ", joinType=" + this.joinType + ", condition=" + this.condition + ")";
        }
    }
}

