/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.GroupByStrategy;
import org.partiql.ast.Identifier;
import org.partiql.ast.expr.Expr;

public final class GroupBy
extends AstNode {
    @NotNull
    private final GroupByStrategy strategy;
    @NotNull
    private final List<Key> keys;
    @Nullable
    private final Identifier.Simple asAlias;

    public GroupBy(@NotNull GroupByStrategy strategy, @NotNull List<Key> keys, @Nullable Identifier.Simple asAlias) {
        this.strategy = strategy;
        this.keys = keys;
        this.asAlias = asAlias;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>(this.keys);
        if (this.asAlias != null) {
            kids.add(this.asAlias);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitGroupBy(this, ctx);
    }

    @NotNull
    public GroupByStrategy getStrategy() {
        return this.strategy;
    }

    @NotNull
    public List<Key> getKeys() {
        return this.keys;
    }

    @Nullable
    public Identifier.Simple getAsAlias() {
        return this.asAlias;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupBy)) {
            return false;
        }
        GroupBy other = (GroupBy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GroupByStrategy this$strategy = this.getStrategy();
        GroupByStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy)) {
            return false;
        }
        List<Key> this$keys = this.getKeys();
        List<Key> other$keys = other.getKeys();
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        Identifier.Simple this$asAlias = this.getAsAlias();
        Identifier.Simple other$asAlias = other.getAsAlias();
        return !(this$asAlias == null ? other$asAlias != null : !((Object)this$asAlias).equals(other$asAlias));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupBy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GroupByStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : ((Object)$strategy).hashCode());
        List<Key> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        Identifier.Simple $asAlias = this.getAsAlias();
        result = result * 59 + ($asAlias == null ? 43 : ((Object)$asAlias).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private GroupByStrategy strategy;
        @Generated
        private List<Key> keys;
        @Generated
        private Identifier.Simple asAlias;

        @Generated
        Builder() {
        }

        @Generated
        public Builder strategy(@NotNull GroupByStrategy strategy) {
            if (strategy == null) {
                throw new NullPointerException("strategy is marked non-null but is null");
            }
            this.strategy = strategy;
            return this;
        }

        @Generated
        public Builder keys(@NotNull List<Key> keys) {
            if (keys == null) {
                throw new NullPointerException("keys is marked non-null but is null");
            }
            this.keys = keys;
            return this;
        }

        @Generated
        public Builder asAlias(@Nullable Identifier.Simple asAlias) {
            this.asAlias = asAlias;
            return this;
        }

        @Generated
        public GroupBy build() {
            return new GroupBy(this.strategy, this.keys, this.asAlias);
        }

        @Generated
        public String toString() {
            return "GroupBy.Builder(strategy=" + this.strategy + ", keys=" + this.keys + ", asAlias=" + this.asAlias + ")";
        }
    }

    public static class Key
    extends AstNode {
        @NotNull
        private final Expr expr;
        @Nullable
        private final Identifier.Simple asAlias;

        public Key(@NotNull Expr expr, @Nullable Identifier.Simple asAlias) {
            this.expr = expr;
            this.asAlias = asAlias;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.add(this.expr);
            if (this.asAlias != null) {
                kids.add(this.asAlias);
            }
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitGroupByKey(this, ctx);
        }

        @NotNull
        public Expr getExpr() {
            return this.expr;
        }

        @Nullable
        public Identifier.Simple getAsAlias() {
            return this.asAlias;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expr this$expr = this.getExpr();
            Expr other$expr = other.getExpr();
            if (this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr)) {
                return false;
            }
            Identifier.Simple this$asAlias = this.getAsAlias();
            Identifier.Simple other$asAlias = other.getAsAlias();
            return !(this$asAlias == null ? other$asAlias != null : !((Object)this$asAlias).equals(other$asAlias));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expr $expr = this.getExpr();
            result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
            Identifier.Simple $asAlias = this.getAsAlias();
            result = result * 59 + ($asAlias == null ? 43 : ((Object)$asAlias).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private Expr expr;
            @Generated
            private Identifier.Simple asAlias;

            @Generated
            Builder() {
            }

            @Generated
            public Builder expr(@NotNull Expr expr) {
                if (expr == null) {
                    throw new NullPointerException("expr is marked non-null but is null");
                }
                this.expr = expr;
                return this;
            }

            @Generated
            public Builder asAlias(@Nullable Identifier.Simple asAlias) {
                this.asAlias = asAlias;
                return this;
            }

            @Generated
            public Key build() {
                return new Key(this.expr, this.asAlias);
            }

            @Generated
            public String toString() {
                return "GroupBy.Key.Builder(expr=" + this.expr + ", asAlias=" + this.asAlias + ")";
            }
        }
    }
}

