/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class GroupByStrategy
extends AstEnum {
    public static final int FULL = 0;
    public static final int PARTIAL = 1;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1};

    public static GroupByStrategy FULL() {
        return new GroupByStrategy(0);
    }

    public static GroupByStrategy PARTIAL() {
        return new GroupByStrategy(1);
    }

    private GroupByStrategy(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "FULL";
            }
            case 1: {
                return "PARTIAL";
            }
        }
        throw new IllegalStateException("Invalid GroupByStrategy code: " + this.code);
    }

    @NotNull
    public static GroupByStrategy parse(@NotNull String value) {
        switch (value) {
            case "FULL": {
                return GroupByStrategy.FULL();
            }
            case "PARTIAL": {
                return GroupByStrategy.PARTIAL();
            }
        }
        throw new IllegalArgumentException("No enum constant GroupByStrategy." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupByStrategy)) {
            return false;
        }
        GroupByStrategy other = (GroupByStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroupByStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

