/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class Identifier
extends AstNode {
    @NotNull
    private final List<Simple> qualifier;
    @NotNull
    private final Simple identifier;

    public Identifier(@NotNull List<Simple> qualifier, @NotNull Simple identifier) {
        this.qualifier = qualifier;
        this.identifier = identifier;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>(this.qualifier);
        kids.add(this.identifier);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitIdentifier(this, ctx);
    }

    @NotNull
    public List<Simple> getQualifier() {
        return this.qualifier;
    }

    @NotNull
    public Simple getIdentifier() {
        return this.identifier;
    }

    public boolean hasQualifier() {
        return !this.qualifier.isEmpty();
    }

    @NotNull
    public static Identifier regular(@NotNull String text) {
        return new Identifier(Collections.emptyList(), Simple.regular(text));
    }

    @NotNull
    public static Identifier regular(String ... parts) {
        return Identifier.regular(Arrays.asList(parts));
    }

    @NotNull
    public static Identifier regular(@NotNull List<String> parts) {
        if (parts.isEmpty()) {
            throw new IllegalStateException("Cannot create an identifier with no parts");
        }
        List<Simple> qualifier = parts.subList(0, parts.size() - 1).stream().map(Simple::regular).collect(Collectors.toList());
        Simple identifier = Simple.regular(parts.get(parts.size() - 1));
        return new Identifier(qualifier, identifier);
    }

    @NotNull
    public static Identifier delimited(@NotNull String text) {
        return new Identifier(Collections.emptyList(), Simple.delimited(text));
    }

    @NotNull
    public static Identifier delimited(String ... parts) {
        return Identifier.delimited(Arrays.asList(parts));
    }

    @NotNull
    public static Identifier delimited(@NotNull List<String> parts) {
        if (parts.isEmpty()) {
            throw new IllegalStateException("Cannot create an identifier with no parts");
        }
        List<Simple> qualifier = parts.subList(0, parts.size() - 1).stream().map(Simple::delimited).collect(Collectors.toList());
        Simple identifier = Simple.delimited(parts.get(parts.size() - 1));
        return new Identifier(qualifier, identifier);
    }

    @NotNull
    public static Identifier of(Simple ... parts) {
        return Identifier.of(Arrays.asList(parts));
    }

    @NotNull
    public static Identifier of(@NotNull List<Simple> parts) {
        if (parts.isEmpty()) {
            throw new IllegalStateException("Cannot create an identifier with no parts");
        }
        List<Simple> qualifier = parts.subList(0, parts.size() - 1);
        Simple identifier = parts.get(parts.size() - 1);
        return new Identifier(qualifier, identifier);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Identifier)) {
            return false;
        }
        Identifier other = (Identifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Simple> this$qualifier = this.getQualifier();
        List<Simple> other$qualifier = other.getQualifier();
        if (this$qualifier == null ? other$qualifier != null : !((Object)this$qualifier).equals(other$qualifier)) {
            return false;
        }
        Simple this$identifier = this.getIdentifier();
        Simple other$identifier = other.getIdentifier();
        return !(this$identifier == null ? other$identifier != null : !((Object)this$identifier).equals(other$identifier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Identifier;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Simple> $qualifier = this.getQualifier();
        result = result * 59 + ($qualifier == null ? 43 : ((Object)$qualifier).hashCode());
        Simple $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : ((Object)$identifier).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private List<Simple> qualifier;
        @Generated
        private Simple identifier;

        @Generated
        Builder() {
        }

        @Generated
        public Builder qualifier(@NotNull List<Simple> qualifier) {
            if (qualifier == null) {
                throw new NullPointerException("qualifier is marked non-null but is null");
            }
            this.qualifier = qualifier;
            return this;
        }

        @Generated
        public Builder identifier(@NotNull Simple identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier is marked non-null but is null");
            }
            this.identifier = identifier;
            return this;
        }

        @Generated
        public Identifier build() {
            return new Identifier(this.qualifier, this.identifier);
        }

        @Generated
        public String toString() {
            return "Identifier.Builder(qualifier=" + this.qualifier + ", identifier=" + this.identifier + ")";
        }
    }

    public static final class Simple
    extends AstNode {
        @NotNull
        private final String text;
        private final boolean regular;

        public Simple(@NotNull String text, boolean regular) {
            this.text = text;
            this.regular = regular;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            return new ArrayList<AstNode>();
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitIdentifierSimple(this, ctx);
        }

        @NotNull
        public String getText() {
            return this.text;
        }

        public boolean isRegular() {
            return this.regular;
        }

        @NotNull
        public static Simple regular(@NotNull String text) {
            return new Simple(text, true);
        }

        @NotNull
        public static Simple delimited(@NotNull String text) {
            return new Simple(text, false);
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isRegular() != other.isRegular()) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Simple;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isRegular() ? 79 : 97);
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private String text;
            @Generated
            private boolean regular;

            @Generated
            Builder() {
            }

            @Generated
            public Builder text(@NotNull String text) {
                if (text == null) {
                    throw new NullPointerException("text is marked non-null but is null");
                }
                this.text = text;
                return this;
            }

            @Generated
            public Builder regular(boolean regular) {
                this.regular = regular;
                return this;
            }

            @Generated
            public Simple build() {
                return new Simple(this.text, this.regular);
            }

            @Generated
            public String toString() {
                return "Identifier.Simple.Builder(text=" + this.text + ", regular=" + this.regular + ")";
            }
        }
    }
}

