/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.DatetimeField;

public abstract class IntervalQualifier
extends AstNode {
    private static final int MAX_PRECISION = 6;

    public static final class Single
    extends IntervalQualifier {
        @NotNull
        private final DatetimeField field;
        @Nullable
        private final Integer precision;
        @Nullable
        private final Integer fractionalPrecision;
        private static Set<Integer> ALLOWABLE_FIELDS = new HashSet<Integer>(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(3);
                this.add(4);
                this.add(5);
            }
        };

        @NotNull
        public DatetimeField getField() {
            return this.field;
        }

        @Nullable
        public Integer getPrecision() {
            return this.precision;
        }

        @Nullable
        public Integer getFractionalPrecision() {
            return this.fractionalPrecision;
        }

        public Single(@NotNull DatetimeField field, @Nullable Integer precision, @Nullable Integer fractionalPrecision) throws IllegalArgumentException {
            Single.checkInputs(field, precision, fractionalPrecision);
            this.field = field;
            this.precision = precision;
            this.fractionalPrecision = fractionalPrecision;
        }

        private static void checkInputs(@NotNull DatetimeField field, @Nullable Integer precision, @Nullable Integer scale) {
            int code = field.code();
            if (!ALLOWABLE_FIELDS.contains(code)) {
                throw new IllegalArgumentException("Invalid interval field: " + field.name());
            }
            if (precision != null && precision <= 0) {
                throw new IllegalArgumentException("Invalid precision" + precision);
            }
            if (scale != null && code != 5) {
                throw new IllegalArgumentException("Cannot specify fractional seconds precision for interval field: " + field.name());
            }
            if (scale != null && scale < 0) {
                throw new IllegalArgumentException("Invalid scale" + scale);
            }
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.add(this.field);
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitIntervalQualifierSingle(this, ctx);
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Single)) {
                return false;
            }
            Single other = (Single)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$precision = this.getPrecision();
            Integer other$precision = other.getPrecision();
            if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
                return false;
            }
            Integer this$fractionalPrecision = this.getFractionalPrecision();
            Integer other$fractionalPrecision = other.getFractionalPrecision();
            if (this$fractionalPrecision == null ? other$fractionalPrecision != null : !((Object)this$fractionalPrecision).equals(other$fractionalPrecision)) {
                return false;
            }
            DatetimeField this$field = this.getField();
            DatetimeField other$field = other.getField();
            return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Single;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $precision = this.getPrecision();
            result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
            Integer $fractionalPrecision = this.getFractionalPrecision();
            result = result * 59 + ($fractionalPrecision == null ? 43 : ((Object)$fractionalPrecision).hashCode());
            DatetimeField $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private DatetimeField field;
            @Generated
            private Integer precision;
            @Generated
            private Integer fractionalPrecision;

            @Generated
            Builder() {
            }

            @Generated
            public Builder field(@NotNull DatetimeField field) {
                if (field == null) {
                    throw new NullPointerException("field is marked non-null but is null");
                }
                this.field = field;
                return this;
            }

            @Generated
            public Builder precision(@Nullable Integer precision) {
                this.precision = precision;
                return this;
            }

            @Generated
            public Builder fractionalPrecision(@Nullable Integer fractionalPrecision) {
                this.fractionalPrecision = fractionalPrecision;
                return this;
            }

            @Generated
            public Single build() {
                return new Single(this.field, this.precision, this.fractionalPrecision);
            }

            @Generated
            public String toString() {
                return "IntervalQualifier.Single.Builder(field=" + this.field + ", precision=" + this.precision + ", fractionalPrecision=" + this.fractionalPrecision + ")";
            }
        }
    }

    public static final class Range
    extends IntervalQualifier {
        @NotNull
        private final DatetimeField startField;
        @Nullable
        private final Integer leadingFieldPrecision;
        @NotNull
        private final DatetimeField endField;
        @Nullable
        private final Integer endFieldFractionalPrecision;
        private static Set<Integer> ALLOWABLE_START_FIELDS = new HashSet<Integer>(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(3);
                this.add(4);
            }
        };
        private static Set<Integer> ALLOWABLE_END_FIELDS = new HashSet<Integer>(){
            {
                this.add(0);
                this.add(1);
                this.add(2);
                this.add(3);
                this.add(4);
                this.add(5);
            }
        };

        @NotNull
        public DatetimeField getStartField() {
            return this.startField;
        }

        @Nullable
        public Integer getStartFieldPrecision() {
            return this.leadingFieldPrecision;
        }

        @NotNull
        public DatetimeField getEndField() {
            return this.endField;
        }

        @Nullable
        public Integer getEndFieldFractionalPrecision() {
            return this.endFieldFractionalPrecision;
        }

        public Range(@NotNull DatetimeField startField, @Nullable Integer startFieldPrecision, @NotNull DatetimeField endField, @Nullable Integer endFieldFractionalPrecision) throws IllegalArgumentException {
            Range.checkStartField(startField, startFieldPrecision);
            Range.checkEndField(endField, endFieldFractionalPrecision);
            this.startField = startField;
            this.leadingFieldPrecision = startFieldPrecision;
            this.endField = endField;
            this.endFieldFractionalPrecision = endFieldFractionalPrecision;
        }

        private static void checkStartField(@NotNull DatetimeField startField, @Nullable Integer startFieldPrecision) throws IllegalArgumentException {
            int startCode = startField.code();
            if (!ALLOWABLE_START_FIELDS.contains(startCode)) {
                throw new IllegalArgumentException("Invalid interval start field: " + startField.name());
            }
            if (startFieldPrecision != null && (startFieldPrecision <= 0 || startFieldPrecision > 6)) {
                throw new IllegalArgumentException("Invalid leading field precision" + startFieldPrecision);
            }
        }

        private static void checkEndField(@NotNull DatetimeField endField, @Nullable Integer endFieldPrecision) throws IllegalArgumentException {
            int code = endField.code();
            if (!ALLOWABLE_END_FIELDS.contains(code)) {
                throw new IllegalArgumentException("Invalid interval end field: " + endField.name());
            }
            if (endFieldPrecision != null && code != 5) {
                throw new IllegalArgumentException("Cannot specify fractional seconds precision for interval end field: " + endField.name());
            }
            if (endFieldPrecision != null && (endFieldPrecision < 0 || endFieldPrecision > 6)) {
                throw new IllegalArgumentException("Invalid end field precision" + endFieldPrecision);
            }
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.add(this.startField);
            kids.add(this.endField);
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitIntervalQualifierRange(this, ctx);
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range other = (Range)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$leadingFieldPrecision = this.leadingFieldPrecision;
            Integer other$leadingFieldPrecision = other.leadingFieldPrecision;
            if (this$leadingFieldPrecision == null ? other$leadingFieldPrecision != null : !((Object)this$leadingFieldPrecision).equals(other$leadingFieldPrecision)) {
                return false;
            }
            Integer this$endFieldFractionalPrecision = this.getEndFieldFractionalPrecision();
            Integer other$endFieldFractionalPrecision = other.getEndFieldFractionalPrecision();
            if (this$endFieldFractionalPrecision == null ? other$endFieldFractionalPrecision != null : !((Object)this$endFieldFractionalPrecision).equals(other$endFieldFractionalPrecision)) {
                return false;
            }
            DatetimeField this$startField = this.getStartField();
            DatetimeField other$startField = other.getStartField();
            if (this$startField == null ? other$startField != null : !((Object)this$startField).equals(other$startField)) {
                return false;
            }
            DatetimeField this$endField = this.getEndField();
            DatetimeField other$endField = other.getEndField();
            return !(this$endField == null ? other$endField != null : !((Object)this$endField).equals(other$endField));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Range;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $leadingFieldPrecision = this.leadingFieldPrecision;
            result = result * 59 + ($leadingFieldPrecision == null ? 43 : ((Object)$leadingFieldPrecision).hashCode());
            Integer $endFieldFractionalPrecision = this.getEndFieldFractionalPrecision();
            result = result * 59 + ($endFieldFractionalPrecision == null ? 43 : ((Object)$endFieldFractionalPrecision).hashCode());
            DatetimeField $startField = this.getStartField();
            result = result * 59 + ($startField == null ? 43 : ((Object)$startField).hashCode());
            DatetimeField $endField = this.getEndField();
            result = result * 59 + ($endField == null ? 43 : ((Object)$endField).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private DatetimeField startField;
            @Generated
            private Integer leadingFieldPrecision;
            @Generated
            private DatetimeField endField;
            @Generated
            private Integer endFieldFractionalPrecision;

            @Generated
            Builder() {
            }

            @Generated
            public Builder startField(@NotNull DatetimeField startField) {
                if (startField == null) {
                    throw new NullPointerException("startField is marked non-null but is null");
                }
                this.startField = startField;
                return this;
            }

            @Generated
            public Builder leadingFieldPrecision(@Nullable Integer leadingFieldPrecision) {
                this.leadingFieldPrecision = leadingFieldPrecision;
                return this;
            }

            @Generated
            public Builder endField(@NotNull DatetimeField endField) {
                if (endField == null) {
                    throw new NullPointerException("endField is marked non-null but is null");
                }
                this.endField = endField;
                return this;
            }

            @Generated
            public Builder endFieldFractionalPrecision(@Nullable Integer endFieldFractionalPrecision) {
                this.endFieldFractionalPrecision = endFieldFractionalPrecision;
                return this;
            }

            @Generated
            public Range build() {
                return new Range(this.startField, this.leadingFieldPrecision, this.endField, this.endFieldFractionalPrecision);
            }

            @Generated
            public String toString() {
                return "IntervalQualifier.Range.Builder(startField=" + this.startField + ", leadingFieldPrecision=" + this.leadingFieldPrecision + ", endField=" + this.endField + ", endFieldFractionalPrecision=" + this.endFieldFractionalPrecision + ")";
            }
        }
    }
}

