/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class JoinType
extends AstEnum {
    public static final int INNER = 0;
    public static final int LEFT = 1;
    public static final int LEFT_OUTER = 2;
    public static final int RIGHT = 3;
    public static final int RIGHT_OUTER = 4;
    public static final int FULL = 5;
    public static final int FULL_OUTER = 6;
    public static final int CROSS = 7;
    public static final int LEFT_CROSS = 8;
    public static final int RIGHT_CROSS = 9;
    public static final int INNER_CROSS = 10;
    public static final int FULL_CROSS = 11;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};

    public static JoinType INNER() {
        return new JoinType(0);
    }

    public static JoinType LEFT() {
        return new JoinType(1);
    }

    public static JoinType LEFT_OUTER() {
        return new JoinType(2);
    }

    public static JoinType RIGHT() {
        return new JoinType(3);
    }

    public static JoinType RIGHT_OUTER() {
        return new JoinType(4);
    }

    public static JoinType FULL() {
        return new JoinType(5);
    }

    public static JoinType FULL_OUTER() {
        return new JoinType(6);
    }

    public static JoinType CROSS() {
        return new JoinType(7);
    }

    public static JoinType LEFT_CROSS() {
        return new JoinType(8);
    }

    public static JoinType RIGHT_CROSS() {
        return new JoinType(9);
    }

    public static JoinType INNER_CROSS() {
        return new JoinType(10);
    }

    public static JoinType FULL_CROSS() {
        return new JoinType(11);
    }

    private JoinType(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "INNER";
            }
            case 1: {
                return "LEFT";
            }
            case 2: {
                return "LEFT_OUTER";
            }
            case 3: {
                return "RIGHT";
            }
            case 4: {
                return "RIGHT_OUTER";
            }
            case 5: {
                return "FULL";
            }
            case 6: {
                return "FULL_OUTER";
            }
            case 7: {
                return "CROSS";
            }
            case 8: {
                return "LEFT_CROSS";
            }
            case 9: {
                return "RIGHT_CROSS";
            }
            case 10: {
                return "INNER_CROSS";
            }
            case 11: {
                return "FULL_CROSS";
            }
        }
        throw new IllegalStateException("Invalid JoinType code: " + this.code);
    }

    @NotNull
    public static JoinType parse(@NotNull String value) {
        switch (value) {
            case "INNER": {
                return JoinType.INNER();
            }
            case "LEFT": {
                return JoinType.LEFT();
            }
            case "LEFT_OUTER": {
                return JoinType.LEFT_OUTER();
            }
            case "RIGHT": {
                return JoinType.RIGHT();
            }
            case "RIGHT_OUTER": {
                return JoinType.RIGHT_OUTER();
            }
            case "FULL": {
                return JoinType.FULL();
            }
            case "FULL_OUTER": {
                return JoinType.FULL_OUTER();
            }
            case "CROSS": {
                return JoinType.CROSS();
            }
            case "LEFT_CROSS": {
                return JoinType.LEFT_CROSS();
            }
        }
        throw new IllegalArgumentException("No enum constant JoinType." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinType)) {
            return false;
        }
        JoinType other = (JoinType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JoinType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

