/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.expr.Expr;

public final class Let
extends AstNode {
    @NotNull
    private final List<Binding> bindings;

    public Let(@NotNull List<Binding> bindings) {
        this.bindings = bindings;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return new ArrayList<AstNode>(this.bindings);
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitLet(this, ctx);
    }

    @NotNull
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Let)) {
            return false;
        }
        Let other = (Let)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Binding> this$bindings = this.getBindings();
        List<Binding> other$bindings = other.getBindings();
        return !(this$bindings == null ? other$bindings != null : !((Object)this$bindings).equals(other$bindings));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Let;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Binding> $bindings = this.getBindings();
        result = result * 59 + ($bindings == null ? 43 : ((Object)$bindings).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private List<Binding> bindings;

        @Generated
        Builder() {
        }

        @Generated
        public Builder bindings(@NotNull List<Binding> bindings) {
            if (bindings == null) {
                throw new NullPointerException("bindings is marked non-null but is null");
            }
            this.bindings = bindings;
            return this;
        }

        @Generated
        public Let build() {
            return new Let(this.bindings);
        }

        @Generated
        public String toString() {
            return "Let.Builder(bindings=" + this.bindings + ")";
        }
    }

    public static class Binding
    extends AstNode {
        @NotNull
        private final Expr expr;
        @NotNull
        private final Identifier.Simple asAlias;

        public Binding(@NotNull Expr expr, @NotNull Identifier.Simple asAlias) {
            this.expr = expr;
            this.asAlias = asAlias;
        }

        @Override
        @NotNull
        public List<AstNode> getChildren() {
            ArrayList<AstNode> kids = new ArrayList<AstNode>();
            kids.add(this.expr);
            kids.add(this.asAlias);
            return kids;
        }

        @Override
        public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
            return visitor.visitLetBinding(this, ctx);
        }

        @NotNull
        public Expr getExpr() {
            return this.expr;
        }

        @NotNull
        public Identifier.Simple getAsAlias() {
            return this.asAlias;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding other = (Binding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Expr this$expr = this.getExpr();
            Expr other$expr = other.getExpr();
            if (this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr)) {
                return false;
            }
            Identifier.Simple this$asAlias = this.getAsAlias();
            Identifier.Simple other$asAlias = other.getAsAlias();
            return !(this$asAlias == null ? other$asAlias != null : !((Object)this$asAlias).equals(other$asAlias));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Binding;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Expr $expr = this.getExpr();
            result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
            Identifier.Simple $asAlias = this.getAsAlias();
            result = result * 59 + ($asAlias == null ? 43 : ((Object)$asAlias).hashCode());
            return result;
        }

        @Generated
        public static class Builder {
            @Generated
            private Expr expr;
            @Generated
            private Identifier.Simple asAlias;

            @Generated
            Builder() {
            }

            @Generated
            public Builder expr(@NotNull Expr expr) {
                if (expr == null) {
                    throw new NullPointerException("expr is marked non-null but is null");
                }
                this.expr = expr;
                return this;
            }

            @Generated
            public Builder asAlias(@NotNull Identifier.Simple asAlias) {
                if (asAlias == null) {
                    throw new NullPointerException("asAlias is marked non-null but is null");
                }
                this.asAlias = asAlias;
                return this;
            }

            @Generated
            public Binding build() {
                return new Binding(this.expr, this.asAlias);
            }

            @Generated
            public String toString() {
                return "Let.Binding.Builder(expr=" + this.expr + ", asAlias=" + this.asAlias + ")";
            }
        }
    }
}

