/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.DataType;

public final class Literal
extends AstEnum {
    public static final int NULL = 0;
    public static final int MISSING = 1;
    public static final int BOOL = 2;
    public static final int APPROX_NUM = 3;
    public static final int EXACT_NUM = 4;
    public static final int INT_NUM = 5;
    public static final int STRING = 6;
    public static final int TYPED_STRING = 7;
    private final int code;
    private final Boolean boolValue;
    private final String stringValue;
    private final DataType dataType;

    private Literal(int code, Boolean value, String stringValue, DataType dataType) {
        this.code = code;
        this.boolValue = value;
        this.stringValue = stringValue;
        this.dataType = dataType;
    }

    private Literal(int code) {
        this.code = code;
        this.boolValue = null;
        this.stringValue = null;
        this.dataType = null;
    }

    private Literal(boolean value) {
        this.code = 2;
        this.boolValue = value;
        this.stringValue = null;
        this.dataType = null;
    }

    private Literal(int code, String value) {
        this.code = code;
        this.stringValue = value;
        this.boolValue = null;
        this.dataType = null;
    }

    private Literal(DataType dataType, String value) {
        this.code = 7;
        this.stringValue = value;
        this.dataType = dataType;
        this.boolValue = null;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "NULL";
            }
            case 1: {
                return "MISSING";
            }
            case 2: {
                return "BOOL";
            }
            case 3: {
                return "APPROX_NUM";
            }
            case 4: {
                return "EXACT_NUM";
            }
            case 5: {
                return "INT_NUM";
            }
            case 6: {
                return "STRING";
            }
            case 7: {
                return "TYPED_STRING";
            }
        }
        throw new IllegalStateException("Invalid Literal code: " + this.code);
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitLiteral(this, ctx);
    }

    @NotNull
    public static Literal approxNum(@NotNull String value) {
        return new Literal(3, value);
    }

    @NotNull
    public static Literal bool(boolean value) {
        return new Literal(value);
    }

    @NotNull
    public static Literal exactNum(@NotNull BigDecimal value) {
        if (value.scale() == 0) {
            return new Literal(4, value + ".");
        }
        return new Literal(4, value.toString());
    }

    @NotNull
    public static Literal exactNum(@NotNull String value) {
        return new Literal(4, value);
    }

    @NotNull
    public static Literal intNum(int value) {
        return new Literal(5, Integer.toString(value));
    }

    @NotNull
    public static Literal intNum(long value) {
        return new Literal(5, Long.toString(value));
    }

    @NotNull
    public static Literal intNum(@NotNull BigInteger value) {
        return new Literal(5, value.toString());
    }

    @NotNull
    public static Literal intNum(@NotNull String value) {
        return new Literal(5, value);
    }

    @NotNull
    public static Literal nul() {
        return new Literal(0);
    }

    @NotNull
    public static Literal missing() {
        return new Literal(1);
    }

    @NotNull
    public static Literal string(@NotNull String value) {
        return new Literal(6, value);
    }

    @NotNull
    public static Literal typedString(@NotNull DataType type, @NotNull String value) {
        return new Literal(type, value);
    }

    public boolean booleanValue() {
        if (this.code == 2) {
            Objects.requireNonNull(this.boolValue, "bool value");
            return this.boolValue;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String numberValue() {
        switch (this.code) {
            case 3: 
            case 4: 
            case 5: {
                Objects.requireNonNull(this.stringValue, "string value for numerics");
                return this.stringValue;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public BigDecimal bigDecimalValue() {
        switch (this.code) {
            case 4: 
            case 5: {
                Objects.requireNonNull(this.stringValue, "string value for exact and int numerics");
                return new BigDecimal(this.stringValue);
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String stringValue() {
        switch (this.code) {
            case 6: 
            case 7: {
                Objects.requireNonNull(this.stringValue, "string value");
                return this.stringValue;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public DataType dataType() {
        if (this.code == 7) {
            Objects.requireNonNull(this.dataType, "data type");
            return this.dataType;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Literal)) {
            return false;
        }
        Literal other = (Literal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.code != other.code) {
            return false;
        }
        Boolean this$boolValue = this.boolValue;
        Boolean other$boolValue = other.boolValue;
        if (this$boolValue == null ? other$boolValue != null : !((Object)this$boolValue).equals(other$boolValue)) {
            return false;
        }
        String this$stringValue = this.stringValue;
        String other$stringValue = other.stringValue;
        if (this$stringValue == null ? other$stringValue != null : !this$stringValue.equals(other$stringValue)) {
            return false;
        }
        DataType this$dataType = this.dataType;
        DataType other$dataType = other.dataType;
        return !(this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Literal;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        Boolean $boolValue = this.boolValue;
        result = result * 59 + ($boolValue == null ? 43 : ((Object)$boolValue).hashCode());
        String $stringValue = this.stringValue;
        result = result * 59 + ($stringValue == null ? 43 : $stringValue.hashCode());
        DataType $dataType = this.dataType;
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        return result;
    }
}

