/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class Order
extends AstEnum {
    public static final int ASC = 0;
    public static final int DESC = 1;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1};

    public static Order ASC() {
        return new Order(0);
    }

    public static Order DESC() {
        return new Order(1);
    }

    private Order(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "ASC";
            }
            case 1: {
                return "DESC";
            }
        }
        throw new IllegalStateException("Invalid Order code: " + this.code);
    }

    @NotNull
    public static Order parse(@NotNull String value) {
        switch (value) {
            case "ASC": {
                return Order.ASC();
            }
            case "DESC": {
                return Order.DESC();
            }
        }
        throw new IllegalArgumentException("No enum constant Order." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

