/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.partiql.ast.AstEnum;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;

public final class SetOpType
extends AstEnum {
    public static final int UNION = 0;
    public static final int INTERSECT = 1;
    public static final int EXCEPT = 2;
    private final int code;
    @NotNull
    private static final int[] codes = new int[]{0, 1, 2};

    public static SetOpType UNION() {
        return new SetOpType(0);
    }

    public static SetOpType INTERSECT() {
        return new SetOpType(1);
    }

    public static SetOpType EXCEPT() {
        return new SetOpType(2);
    }

    private SetOpType(int code) {
        this.code = code;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    @NotNull
    public String name() {
        switch (this.code) {
            case 0: {
                return "UNION";
            }
            case 1: {
                return "INTERSECT";
            }
            case 2: {
                return "EXCEPT";
            }
        }
        throw new IllegalStateException("Invalid SetOpType code: " + this.code);
    }

    @NotNull
    public static SetOpType parse(@NotNull String value) {
        switch (value) {
            case "UNION": {
                return SetOpType.UNION();
            }
            case "INTERSECT": {
                return SetOpType.INTERSECT();
            }
            case "EXCEPT": {
                return SetOpType.EXCEPT();
            }
        }
        throw new IllegalArgumentException("No enum constant SetOpType." + value);
    }

    @NotNull
    public static int[] codes() {
        return codes;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetOpType)) {
            return false;
        }
        SetOpType other = (SetOpType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.code == other.code;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SetOpType;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code;
        return result;
    }
}

