/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.expr.ExprQuerySet;

public final class WithListElement
extends AstNode {
    @NotNull
    private final Identifier.Simple queryName;
    @NotNull
    private final ExprQuerySet asQuery;
    @Nullable
    private final List<Identifier.Simple> withColumnList;

    public WithListElement(@NotNull Identifier.Simple queryName, @NotNull ExprQuerySet asQuery, @Nullable List<Identifier.Simple> columnList) {
        this.queryName = queryName;
        this.asQuery = asQuery;
        this.withColumnList = columnList;
    }

    public WithListElement(@NotNull Identifier.Simple queryName, @NotNull ExprQuerySet asQuery) {
        this(queryName, asQuery, null);
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> children = new ArrayList<AstNode>();
        children.add(this.queryName);
        if (this.withColumnList != null) {
            children.addAll(this.withColumnList);
        }
        children.add(this.asQuery);
        return children;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitWithListElement(this, ctx);
    }

    @NotNull
    public Identifier.Simple getQueryName() {
        return this.queryName;
    }

    @Nullable
    public List<Identifier.Simple> getColumnList() {
        return this.withColumnList;
    }

    @NotNull
    public ExprQuerySet getAsQuery() {
        return this.asQuery;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WithListElement)) {
            return false;
        }
        WithListElement other = (WithListElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier.Simple this$queryName = this.getQueryName();
        Identifier.Simple other$queryName = other.getQueryName();
        if (this$queryName == null ? other$queryName != null : !((Object)this$queryName).equals(other$queryName)) {
            return false;
        }
        ExprQuerySet this$asQuery = this.getAsQuery();
        ExprQuerySet other$asQuery = other.getAsQuery();
        if (this$asQuery == null ? other$asQuery != null : !((Object)this$asQuery).equals(other$asQuery)) {
            return false;
        }
        List<Identifier.Simple> this$withColumnList = this.withColumnList;
        List<Identifier.Simple> other$withColumnList = other.withColumnList;
        return !(this$withColumnList == null ? other$withColumnList != null : !((Object)this$withColumnList).equals(other$withColumnList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WithListElement;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier.Simple $queryName = this.getQueryName();
        result = result * 59 + ($queryName == null ? 43 : ((Object)$queryName).hashCode());
        ExprQuerySet $asQuery = this.getAsQuery();
        result = result * 59 + ($asQuery == null ? 43 : ((Object)$asQuery).hashCode());
        List<Identifier.Simple> $withColumnList = this.withColumnList;
        result = result * 59 + ($withColumnList == null ? 43 : ((Object)$withColumnList).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Identifier.Simple queryName;
        @Generated
        private ExprQuerySet asQuery;
        @Generated
        private List<Identifier.Simple> withColumnList;

        @Generated
        Builder() {
        }

        @Generated
        public Builder queryName(@NotNull Identifier.Simple queryName) {
            if (queryName == null) {
                throw new NullPointerException("queryName is marked non-null but is null");
            }
            this.queryName = queryName;
            return this;
        }

        @Generated
        public Builder asQuery(@NotNull ExprQuerySet asQuery) {
            if (asQuery == null) {
                throw new NullPointerException("asQuery is marked non-null but is null");
            }
            this.asQuery = asQuery;
            return this;
        }

        @Generated
        public Builder withColumnList(@Nullable List<Identifier.Simple> withColumnList) {
            this.withColumnList = withColumnList;
            return this;
        }

        @Generated
        public WithListElement build() {
            return new WithListElement(this.queryName, this.asQuery, this.withColumnList);
        }

        @Generated
        public String toString() {
            return "WithListElement.Builder(queryName=" + this.queryName + ", asQuery=" + this.asQuery + ", withColumnList=" + this.withColumnList + ")";
        }
    }
}

