/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.ddl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.DataType;
import org.partiql.ast.Identifier;
import org.partiql.ast.ddl.AttributeConstraint;

public final class ColumnDefinition
extends AstNode {
    @NotNull
    private final Identifier.Simple name;
    @NotNull
    private final DataType dataType;
    private final boolean optional;
    @NotNull
    private final List<AttributeConstraint> constraints;
    @Nullable
    private final String comment;

    public ColumnDefinition(@NotNull Identifier.Simple name, @NotNull DataType dataType, boolean optional, @NotNull List<AttributeConstraint> constraints, @Nullable String comment) {
        this.name = name;
        this.dataType = dataType;
        this.optional = optional;
        this.constraints = constraints;
        this.comment = comment;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.name);
        kids.add(this.dataType);
        kids.addAll(this.constraints);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitColumnDefinition(this, ctx);
    }

    @NotNull
    public Identifier.Simple getName() {
        return this.name;
    }

    @NotNull
    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @NotNull
    public List<AttributeConstraint> getConstraints() {
        return this.constraints;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        Identifier.Simple this$name = this.getName();
        Identifier.Simple other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !((Object)this$dataType).equals(other$dataType)) {
            return false;
        }
        List<AttributeConstraint> this$constraints = this.getConstraints();
        List<AttributeConstraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ColumnDefinition;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOptional() ? 79 : 97);
        Identifier.Simple $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)$dataType).hashCode());
        List<AttributeConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Identifier.Simple name;
        @Generated
        private DataType dataType;
        @Generated
        private boolean optional;
        @Generated
        private List<AttributeConstraint> constraints;
        @Generated
        private String comment;

        @Generated
        Builder() {
        }

        @Generated
        public Builder name(@NotNull Identifier.Simple name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder dataType(@NotNull DataType dataType) {
            if (dataType == null) {
                throw new NullPointerException("dataType is marked non-null but is null");
            }
            this.dataType = dataType;
            return this;
        }

        @Generated
        public Builder optional(boolean optional) {
            this.optional = optional;
            return this;
        }

        @Generated
        public Builder constraints(@NotNull List<AttributeConstraint> constraints) {
            if (constraints == null) {
                throw new NullPointerException("constraints is marked non-null but is null");
            }
            this.constraints = constraints;
            return this;
        }

        @Generated
        public Builder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        @Generated
        public ColumnDefinition build() {
            return new ColumnDefinition(this.name, this.dataType, this.optional, this.constraints, this.comment);
        }

        @Generated
        public String toString() {
            return "ColumnDefinition.Builder(name=" + this.name + ", dataType=" + this.dataType + ", optional=" + this.optional + ", constraints=" + this.constraints + ", comment=" + this.comment + ")";
        }
    }
}

