/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.ddl;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.Statement;
import org.partiql.ast.ddl.ColumnDefinition;
import org.partiql.ast.ddl.KeyValue;
import org.partiql.ast.ddl.PartitionBy;
import org.partiql.ast.ddl.TableConstraint;

public final class CreateTable
extends Statement {
    @NotNull
    private final Identifier name;
    @NotNull
    private final List<ColumnDefinition> columns;
    @NotNull
    private final List<TableConstraint> constraints;
    @Nullable
    private final PartitionBy partitionBy;
    @NotNull
    private final List<KeyValue> tableProperties;

    public CreateTable(@NotNull Identifier name, @NotNull List<ColumnDefinition> columns, @NotNull List<TableConstraint> constraints, @Nullable PartitionBy partitionBy, @NotNull List<KeyValue> tableProperties) {
        this.name = name;
        this.columns = columns;
        this.constraints = constraints;
        this.partitionBy = partitionBy;
        this.tableProperties = tableProperties;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.name);
        kids.addAll(this.columns);
        kids.addAll(this.constraints);
        if (this.partitionBy != null) {
            kids.add(this.partitionBy);
        }
        kids.addAll(this.tableProperties);
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitCreateTable(this, ctx);
    }

    @NotNull
    public Identifier getName() {
        return this.name;
    }

    @NotNull
    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    @NotNull
    public List<TableConstraint> getConstraints() {
        return this.constraints;
    }

    @Nullable
    public PartitionBy getPartitionBy() {
        return this.partitionBy;
    }

    @NotNull
    public List<KeyValue> getTableProperties() {
        return this.tableProperties;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTable)) {
            return false;
        }
        CreateTable other = (CreateTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier this$name = this.getName();
        Identifier other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        List<ColumnDefinition> this$columns = this.getColumns();
        List<ColumnDefinition> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<TableConstraint> this$constraints = this.getConstraints();
        List<TableConstraint> other$constraints = other.getConstraints();
        if (this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints)) {
            return false;
        }
        PartitionBy this$partitionBy = this.getPartitionBy();
        PartitionBy other$partitionBy = other.getPartitionBy();
        if (this$partitionBy == null ? other$partitionBy != null : !((Object)this$partitionBy).equals(other$partitionBy)) {
            return false;
        }
        List<KeyValue> this$tableProperties = this.getTableProperties();
        List<KeyValue> other$tableProperties = other.getTableProperties();
        return !(this$tableProperties == null ? other$tableProperties != null : !((Object)this$tableProperties).equals(other$tableProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CreateTable;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        List<ColumnDefinition> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<TableConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        PartitionBy $partitionBy = this.getPartitionBy();
        result = result * 59 + ($partitionBy == null ? 43 : ((Object)$partitionBy).hashCode());
        List<KeyValue> $tableProperties = this.getTableProperties();
        result = result * 59 + ($tableProperties == null ? 43 : ((Object)$tableProperties).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Identifier name;
        @Generated
        private List<ColumnDefinition> columns;
        @Generated
        private List<TableConstraint> constraints;
        @Generated
        private PartitionBy partitionBy;
        @Generated
        private List<KeyValue> tableProperties;

        @Generated
        Builder() {
        }

        @Generated
        public Builder name(@NotNull Identifier name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public Builder columns(@NotNull List<ColumnDefinition> columns) {
            if (columns == null) {
                throw new NullPointerException("columns is marked non-null but is null");
            }
            this.columns = columns;
            return this;
        }

        @Generated
        public Builder constraints(@NotNull List<TableConstraint> constraints) {
            if (constraints == null) {
                throw new NullPointerException("constraints is marked non-null but is null");
            }
            this.constraints = constraints;
            return this;
        }

        @Generated
        public Builder partitionBy(@Nullable PartitionBy partitionBy) {
            this.partitionBy = partitionBy;
            return this;
        }

        @Generated
        public Builder tableProperties(@NotNull List<KeyValue> tableProperties) {
            if (tableProperties == null) {
                throw new NullPointerException("tableProperties is marked non-null but is null");
            }
            this.tableProperties = tableProperties;
            return this;
        }

        @Generated
        public CreateTable build() {
            return new CreateTable(this.name, this.columns, this.constraints, this.partitionBy, this.tableProperties);
        }

        @Generated
        public String toString() {
            return "CreateTable.Builder(name=" + this.name + ", columns=" + this.columns + ", constraints=" + this.constraints + ", partitionBy=" + this.partitionBy + ", tableProperties=" + this.tableProperties + ")";
        }
    }
}

