/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.ast.dml;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.ast.AstNode;
import org.partiql.ast.AstVisitor;
import org.partiql.ast.Identifier;
import org.partiql.ast.Statement;
import org.partiql.ast.expr.Expr;

public final class Delete
extends Statement {
    @NotNull
    private final Identifier tableName;
    @Nullable
    private final Expr condition;

    public Delete(@NotNull Identifier tableName, @Nullable Expr condition) {
        this.tableName = tableName;
        this.condition = condition;
    }

    @Override
    @NotNull
    public List<AstNode> getChildren() {
        ArrayList<AstNode> kids = new ArrayList<AstNode>();
        kids.add(this.tableName);
        if (this.condition != null) {
            kids.add(this.condition);
        }
        return kids;
    }

    @Override
    public <R, C> R accept(@NotNull AstVisitor<R, C> visitor, C ctx) {
        return visitor.visitDelete(this, ctx);
    }

    @NotNull
    public Identifier getTableName() {
        return this.tableName;
    }

    @Nullable
    public Expr getCondition() {
        return this.condition;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Delete)) {
            return false;
        }
        Delete other = (Delete)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier this$tableName = this.getTableName();
        Identifier other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !((Object)this$tableName).equals(other$tableName)) {
            return false;
        }
        Expr this$condition = this.getCondition();
        Expr other$condition = other.getCondition();
        return !(this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Delete;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : ((Object)$tableName).hashCode());
        Expr $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private Identifier tableName;
        @Generated
        private Expr condition;

        @Generated
        Builder() {
        }

        @Generated
        public Builder tableName(@NotNull Identifier tableName) {
            if (tableName == null) {
                throw new NullPointerException("tableName is marked non-null but is null");
            }
            this.tableName = tableName;
            return this;
        }

        @Generated
        public Builder condition(@Nullable Expr condition) {
            this.condition = condition;
            return this;
        }

        @Generated
        public Delete build() {
            return new Delete(this.tableName, this.condition);
        }

        @Generated
        public String toString() {
            return "Delete.Builder(tableName=" + this.tableName + ", condition=" + this.condition + ")";
        }
    }
}

